/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class NullableOnMethodReturnType
extends Recipe {
    public String getDisplayName() {
        return "Move `@Nullable` method annotations to the return type";
    }

    public String getDescription() {
        return "This is the way the cool kids do it.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> visitor = new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (m.getModifiers().isEmpty()) {
                    return m;
                }
                return Objects.requireNonNull(new Annotated.Matcher("*..Nullable").lower(this.getCursor()).findFirst().map(nullable -> {
                    if (nullable.getCursor().getParentTreeCursor().getValue() != m) {
                        return m;
                    }
                    J.MethodDeclaration m2 = m;
                    if ((m2 = m2.withLeadingAnnotations(ListUtils.map((List)m2.getLeadingAnnotations(), a -> a == nullable.getTree() ? null : a))) != m) {
                        m2 = m2.withReturnTypeExpression((TypeTree)new J.AnnotatedType(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.singletonList(((J.Annotation)nullable.getTree()).withPrefix(Space.EMPTY)), m2.getReturnTypeExpression()));
                        m2 = (J.MethodDeclaration)this.autoFormat((J)m2, (J)m2.getReturnTypeExpression(), ctx, this.getCursor().getParentOrThrow());
                        m2 = m2.withPrefix(m2.getPrefix().withWhitespace(m2.getPrefix().getWhitespace().replace("\n\n\n", "\n\n")));
                    }
                    return m2;
                }).orElse(m));
            }
        };
        return Preconditions.check((TreeVisitor)new UsesType("*..Nullable", Boolean.valueOf(false)), (TreeVisitor)visitor);
    }
}

