/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public final class UnnecessaryCatch
extends Recipe {
    @Option(displayName="Include `java.lang.Exception`", description="Whether to include `java.lang.Exception` in the list of checked exceptions to remove. Unlike other checked exceptions, `java.lang.Exception` is also the superclass of unchecked exceptions. So removing `catch(Exception e)` may result in changed runtime behavior in the presence of unchecked exceptions. Default `false`", required=false)
    private final boolean includeJavaLangException;
    @Option(displayName="Include `java.lang.Throwable`", description="Whether to include `java.lang.Throwable` in the list of exceptions to remove. Unlike other checked exceptions, `java.lang.Throwable` is also the superclass of unchecked exceptions. So removing `catch(Throwable e)` may result in changed runtime behavior in the presence of unchecked exceptions. Default `false`", required=false)
    private final boolean includeJavaLangThrowable;

    public String getDisplayName() {
        return "Remove catch for a checked exception if the try block does not throw that exception";
    }

    public String getDescription() {
        return "A refactoring operation may result in a checked exception that is no longer thrown from a `try` block. This recipe will find and remove unnecessary catch blocks.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = super.visitBlock(block, (Object)ctx);
                return b.withStatements(ListUtils.flatMap((List)b.getStatements(), statement -> {
                    J.Try aTry;
                    if (statement instanceof J.Try && (aTry = (J.Try)statement).getCatches().isEmpty() && aTry.getResources() == null && aTry.getFinally() == null) {
                        return ListUtils.map((List)aTry.getBody().getStatements(), tryStat -> (Statement)this.autoFormat((J)tryStat, ctx, this.getCursor()));
                    }
                    return statement;
                }));
            }

            public J.Try visitTry(J.Try tryable, ExecutionContext ctx) {
                J.Try t = super.visitTry(tryable, (Object)ctx);
                final ArrayList thrownExceptions = new ArrayList();
                final AtomicBoolean missingTypeInformation = new AtomicBoolean(false);
                new JavaIsoVisitor<Integer>(){

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                        JavaType.Method methodType = method.getMethodType();
                        if (methodType == null) {
                            missingTypeInformation.set(true);
                        } else {
                            thrownExceptions.addAll(methodType.getThrownExceptions());
                        }
                        return super.visitMethodInvocation(method, (Object)integer);
                    }
                }.visit((Tree)t.getBody(), (Object)0);
                if (missingTypeInformation.get()) {
                    return t;
                }
                return t.withCatches(ListUtils.map((List)t.getCatches(), (i, aCatch) -> {
                    JavaType parameterType = aCatch.getParameter().getType();
                    if (parameterType == null || TypeUtils.isAssignableTo((String)"java.lang.RuntimeException", (JavaType)parameterType)) {
                        return aCatch;
                    }
                    if (!UnnecessaryCatch.this.includeJavaLangException && TypeUtils.isOfClassType((JavaType)parameterType, (String)"java.lang.Exception")) {
                        return aCatch;
                    }
                    if (!UnnecessaryCatch.this.includeJavaLangThrowable && TypeUtils.isOfClassType((JavaType)parameterType, (String)"java.lang.Throwable")) {
                        return aCatch;
                    }
                    for (JavaType e : thrownExceptions) {
                        if (!TypeUtils.isAssignableTo((JavaType)e, (JavaType)parameterType)) continue;
                        return aCatch;
                    }
                    this.maybeRemoveImport(TypeUtils.asFullyQualified((JavaType)parameterType));
                    return null;
                }));
            }
        };
    }

    @Generated
    public UnnecessaryCatch(boolean includeJavaLangException, boolean includeJavaLangThrowable) {
        this.includeJavaLangException = includeJavaLangException;
        this.includeJavaLangThrowable = includeJavaLangThrowable;
    }

    @Generated
    public boolean isIncludeJavaLangException() {
        return this.includeJavaLangException;
    }

    @Generated
    public boolean isIncludeJavaLangThrowable() {
        return this.includeJavaLangThrowable;
    }

    @Generated
    public String toString() {
        return "UnnecessaryCatch(includeJavaLangException=" + this.isIncludeJavaLangException() + ", includeJavaLangThrowable=" + this.isIncludeJavaLangThrowable() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnnecessaryCatch)) {
            return false;
        }
        UnnecessaryCatch other = (UnnecessaryCatch)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isIncludeJavaLangException() != other.isIncludeJavaLangException()) {
            return false;
        }
        return this.isIncludeJavaLangThrowable() == other.isIncludeJavaLangThrowable();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnnecessaryCatch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeJavaLangException() ? 79 : 97);
        result = result * 59 + (this.isIncludeJavaLangThrowable() ? 79 : 97);
        return result;
    }
}

