/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class SimplifyBooleanReturn
extends Recipe {
    public String getDisplayName() {
        return "Simplify boolean return";
    }

    public String getDescription() {
        return "Simplifies Boolean expressions by removing redundancies. For example, `a && true` simplifies to `a`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1126");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate notIfConditionReturn = JavaTemplate.builder((String)"return !(#{any(boolean)});").build();

            public J visitIf(J.If iff, ExecutionContext ctx) {
                J.If i = (J.If)this.visitAndCast((Tree)iff, ctx, (x$0, x$1) -> super.visitIf(x$0, x$1));
                Cursor parent = this.getCursor().getParentTreeCursor();
                if (parent.getValue() instanceof J.Block && parent.getParentOrThrow().getValue() instanceof J.MethodDeclaration && this.thenHasOnlyReturnStatement(iff) && this.elseWithOnlyReturn(i)) {
                    List<Statement> followingStatements = this.followingStatements();
                    Optional<Expression> singleFollowingStatement = Optional.ofNullable(followingStatements.isEmpty() ? null : followingStatements.get(0)).flatMap(stat -> Optional.ofNullable(stat instanceof J.Return ? (J.Return)stat : null)).filter(r -> r.getComments().isEmpty()).map(J.Return::getExpression);
                    if (followingStatements.isEmpty() || singleFollowingStatement.map(r -> this.isLiteralFalse((J)r) || this.isLiteralTrue((J)r)).orElse(false).booleanValue()) {
                        J.Return return_ = this.getReturnIfOnlyStatementInThen(iff).orElse(null);
                        assert (return_ != null);
                        if (!return_.getComments().isEmpty() || this.hasElseWithComment(i.getElsePart())) {
                            return i;
                        }
                        Expression ifCondition = (Expression)i.getIfCondition().getTree();
                        if (this.isLiteralTrue((J)return_.getExpression())) {
                            if (singleFollowingStatement.map(this::isLiteralFalse).orElse(false).booleanValue() && i.getElsePart() == null) {
                                this.doAfterVisit((TreeVisitor)new DeleteStatement(this.followingStatements().get(0)));
                                return this.maybeAutoFormat((J)return_, (J)return_.withExpression(ifCondition), ctx, parent);
                            }
                            if (!singleFollowingStatement.isPresent() && this.getReturnExprIfOnlyStatementInElseThen(i).map(this::isLiteralFalse).orElse(false).booleanValue()) {
                                if (i.getElsePart() != null) {
                                    this.doAfterVisit((TreeVisitor)new DeleteStatement(i.getElsePart().getBody()));
                                }
                                return this.maybeAutoFormat((J)return_, (J)return_.withExpression(ifCondition), ctx, parent);
                            }
                        } else if (this.isLiteralFalse((J)return_.getExpression())) {
                            boolean returnThenPart = false;
                            if (singleFollowingStatement.map(this::isLiteralTrue).orElse(false).booleanValue() && i.getElsePart() == null) {
                                this.doAfterVisit((TreeVisitor)new DeleteStatement(this.followingStatements().get(0)));
                                returnThenPart = true;
                            } else if (!singleFollowingStatement.isPresent() && this.getReturnExprIfOnlyStatementInElseThen(i).map(this::isLiteralTrue).orElse(false).booleanValue()) {
                                if (i.getElsePart() != null) {
                                    this.doAfterVisit((TreeVisitor)new DeleteStatement(i.getElsePart().getBody()));
                                }
                                returnThenPart = true;
                            }
                            if (returnThenPart) {
                                return this.notIfConditionReturn.apply(this.updateCursor((Tree)i), i.getCoordinates().replace(), new Object[]{ifCondition});
                            }
                        }
                    }
                }
                return i;
            }

            private boolean elseWithOnlyReturn(J.If i) {
                return i.getElsePart() == null || !(i.getElsePart().getBody() instanceof J.If);
            }

            private boolean thenHasOnlyReturnStatement(J.If iff) {
                return this.getReturnIfOnlyStatementInThen(iff).map(return_ -> this.isLiteralFalse((J)return_.getExpression()) || this.isLiteralTrue((J)return_.getExpression())).orElse(false);
            }

            private List<Statement> followingStatements() {
                J.Block block = (J.Block)this.getCursor().getParentTreeCursor().getValue();
                AtomicBoolean dropWhile = new AtomicBoolean(false);
                return block.getStatements().stream().filter(s -> {
                    dropWhile.set(dropWhile.get() || s == this.getCursor().getValue());
                    return dropWhile.get();
                }).skip(1L).collect(Collectors.toList());
            }

            private boolean isLiteralTrue(@Nullable J tree) {
                return tree instanceof J.Literal && ((J.Literal)tree).getValue() == Boolean.valueOf(true);
            }

            private boolean isLiteralFalse(@Nullable J tree) {
                return tree instanceof J.Literal && ((J.Literal)tree).getValue() == Boolean.valueOf(false);
            }

            private Optional<J.Return> getReturnIfOnlyStatementInThen(J.If iff) {
                J.Block then;
                if (iff.getThenPart() instanceof J.Return) {
                    return Optional.of((J.Return)iff.getThenPart());
                }
                if (iff.getThenPart() instanceof J.Block && (then = (J.Block)iff.getThenPart()).getStatements().size() == 1 && then.getStatements().get(0) instanceof J.Return) {
                    return Optional.of((J.Return)then.getStatements().get(0));
                }
                return Optional.empty();
            }

            private Optional<Expression> getReturnExprIfOnlyStatementInElseThen(J.If iff2) {
                J statement;
                List statements;
                if (iff2.getElsePart() == null) {
                    return Optional.empty();
                }
                Statement else_ = iff2.getElsePart().getBody();
                if (else_ instanceof J.Return) {
                    return Optional.ofNullable(((J.Return)else_).getExpression());
                }
                if (else_ instanceof J.Block && (statements = ((J.Block)else_).getStatements()).size() == 1 && (statement = (J)statements.get(0)) instanceof J.Return) {
                    return Optional.ofNullable(((J.Return)statement).getExpression());
                }
                return Optional.empty();
            }

            private boolean hasElseWithComment(// Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.If.Else else_) {
                if (else_ == null || else_.getBody() == null) {
                    return false;
                }
                if (!else_.getComments().isEmpty()) {
                    return true;
                }
                if (!else_.getBody().getComments().isEmpty()) {
                    return true;
                }
                return else_.getBody() instanceof J.Block && !((Statement)((J.Block)else_.getBody()).getStatements().get(0)).getComments().isEmpty();
            }
        };
    }
}

