/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceStreamToListWithCollect
extends Recipe {
    private static final MethodMatcher STREAM_TO_LIST = new MethodMatcher("java.util.stream.Stream toList()");

    public String getDisplayName() {
        return "Replace Stream.toList() with Stream.collect(Collectors.toList())";
    }

    public String getDescription() {
        return "Replace Java 16 `Stream.toList()` with Java 11 `Stream.collect(Collectors.toList())`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(16), new UsesMethod(STREAM_TO_LIST)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate template = JavaTemplate.builder((String)"#{any(java.util.stream.Stream)}.collect(Collectors.toList())").imports(new String[]{"java.util.stream.Collectors"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation result = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (STREAM_TO_LIST.matches((MethodCall)method)) {
                    JRightPadded select = result.getPadding().getSelect();
                    result = (J.MethodInvocation)this.template.apply(this.updateCursor((Tree)result), result.getCoordinates().replace(), new Object[]{result.getSelect()});
                    result = result.getPadding().withSelect(select);
                    this.maybeAddImport("java.util.stream.Collectors");
                }
                return result;
            }
        });
    }
}

