/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class PrimitiveWrapperClassConstructorToValueOf
extends Recipe {
    public String getDisplayName() {
        return "Use primitive wrapper `valueOf` method";
    }

    public String getDescription() {
        return "The constructor of all primitive types has been deprecated in favor of using the static factory method `valueOf` available for each of the primitive type wrappers.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2129");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor condition = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.lang.Boolean", Boolean.valueOf(false)), new UsesType("java.lang.Byte", Boolean.valueOf(false)), new UsesType("java.lang.Character", Boolean.valueOf(false)), new UsesType("java.lang.Double", Boolean.valueOf(false)), new UsesType("java.lang.Float", Boolean.valueOf(false)), new UsesType("java.lang.Integer", Boolean.valueOf(false)), new UsesType("java.lang.Long", Boolean.valueOf(false)), new UsesType("java.lang.Short", Boolean.valueOf(false))});
        return Preconditions.check((TreeVisitor)condition, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified((JavaType)nc.getType());
                if (type != null && nc.getArguments().size() == 1) {
                    JavaTemplate.Builder valueOf;
                    Expression arg = (Expression)nc.getArguments().get(0);
                    switch (type.getFullyQualifiedName()) {
                        case "java.lang.Boolean": {
                            valueOf = JavaTemplate.builder((String)"Boolean.valueOf(#{any(boolean)})");
                            break;
                        }
                        case "java.lang.Byte": {
                            valueOf = JavaTemplate.builder((String)"Byte.valueOf(#{any(byte)})");
                            break;
                        }
                        case "java.lang.Character": {
                            valueOf = JavaTemplate.builder((String)"Character.valueOf(#{any(char)})");
                            break;
                        }
                        case "java.lang.Double": {
                            valueOf = JavaTemplate.builder((String)"Double.valueOf(#{any(double)})");
                            break;
                        }
                        case "java.lang.Integer": {
                            valueOf = JavaTemplate.builder((String)"Integer.valueOf(#{any(int)})");
                            break;
                        }
                        case "java.lang.Long": {
                            valueOf = JavaTemplate.builder((String)"Long.valueOf(#{any(long)})");
                            break;
                        }
                        case "java.lang.Short": {
                            valueOf = JavaTemplate.builder((String)"Short.valueOf(#{any(short)})");
                            break;
                        }
                        case "java.lang.Float": {
                            JavaType argType;
                            if (arg instanceof J.Literal && JavaType.Primitive.Double == ((J.Literal)arg).getType()) {
                                arg = ((J.Literal)arg).withType((JavaType)JavaType.Primitive.String);
                                arg = ((J.Literal)arg).withValueSource("\"" + ((J.Literal)arg).getValue() + "\"");
                            }
                            if (TypeUtils.isOfClassType((JavaType)(argType = arg.getType()), (String)"java.lang.Double")) {
                                valueOf = JavaTemplate.builder((String)"Float.valueOf(#{any(java.lang.Double)}.floatValue())");
                                break;
                            }
                            valueOf = JavaTemplate.builder((String)"Float.valueOf(#{any(float)})");
                            break;
                        }
                        default: {
                            return nc;
                        }
                    }
                    return valueOf.build().apply(this.updateCursor((Tree)nc), nc.getCoordinates().replace(), new Object[]{arg});
                }
                return nc;
            }
        });
    }
}

