/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.service.ImportService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.staticanalysis.JavaElementFactory;

public class ReplaceLambdaWithMethodReference
extends Recipe {
    public String getDisplayName() {
        return "Use method references in lambda";
    }

    public String getDescription() {
        return "Replaces the single statement lambdas `o -> o instanceOf X`, `o -> (A) o`, `o -> System.out.println(o)`, `o -> o != null`, `o -> o == null` with the equivalent method reference.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1612");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx, Cursor parent) {
                if (tree instanceof J.CompilationUnit) {
                    return new ReplaceLambdaWithMethodReferenceJavaVisitor().visit(tree, ctx);
                }
                if (tree instanceof K.CompilationUnit) {
                    return new ReplaceLambdaWithMethodReferenceKotlinVisitor().visit(tree, ctx);
                }
                return tree;
            }
        };
    }

    private static boolean isAMethodInvocationArgument(J.Lambda lambda, Cursor cursor) {
        Cursor parent = cursor.dropParentUntil(p -> p instanceof J.MethodInvocation || p instanceof J.CompilationUnit);
        if (parent.getValue() instanceof J.MethodInvocation) {
            J.MethodInvocation m = (J.MethodInvocation)parent.getValue();
            return m.getArguments().stream().anyMatch(arg -> arg == lambda);
        }
        return false;
    }

    private static class ReplaceLambdaWithMethodReferenceJavaVisitor
    extends JavaVisitor<ExecutionContext> {
        private ReplaceLambdaWithMethodReferenceJavaVisitor() {
        }

        public J visitLambda(J.Lambda lambda, ExecutionContext ctx) {
            J.Lambda l = (J.Lambda)super.visitLambda(lambda, (Object)ctx);
            this.updateCursor((Tree)l);
            Object body = l.getBody();
            if (body instanceof J.Block && ((J.Block)body).getStatements().size() == 1) {
                Statement statement = (Statement)((J.Block)body).getStatements().get(0);
                body = statement instanceof J.Return ? ((J.Return)statement).getExpression() : statement;
            }
            if (body instanceof J.InstanceOf) {
                JavaType.FullyQualified rawClassType;
                Optional<JavaType.Method> isInstanceMethod;
                J.FieldAccess classLiteral;
                J.InstanceOf instanceOf = (J.InstanceOf)body;
                J j = instanceOf.getClazz();
                if ((j instanceof J.Identifier || j instanceof J.FieldAccess) && instanceOf.getExpression() instanceof J.Identifier && (classLiteral = JavaElementFactory.newClassLiteral(((TypeTree)j).getType(), j instanceof J.FieldAccess)) != null && (isInstanceMethod = (rawClassType = ((JavaType.Parameterized)classLiteral.getType()).getType()).getMethods().stream().filter(m -> m.getName().equals("isInstance")).findFirst()).isPresent()) {
                    J.MemberReference updated = JavaElementFactory.newInstanceMethodReference((Expression)classLiteral, isInstanceMethod.get(), lambda.getType()).withPrefix(lambda.getPrefix());
                    this.doAfterVisit((TreeVisitor)((ImportService)this.service(ImportService.class)).shortenFullyQualifiedTypeReferencesIn((J)updated));
                    return updated;
                }
                return l;
            }
            if (body instanceof J.TypeCast && l.getParameters().getParameters().size() == 1) {
                JavaType.FullyQualified classType;
                Optional<JavaType.Method> castMethod;
                J.FieldAccess classLiteral;
                J.ControlParentheses j;
                J tree;
                J.TypeCast cast = (J.TypeCast)body;
                J param = (J)l.getParameters().getParameters().get(0);
                if (cast.getExpression() instanceof J.Identifier && param instanceof J.VariableDeclarations && ((J.Identifier)cast.getExpression()).getSimpleName().equals(((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)param).getVariables().get(0)).getSimpleName()) && ((tree = (j = cast.getClazz()).getTree()) instanceof J.Identifier || tree instanceof J.FieldAccess) && !(j.getType() instanceof JavaType.GenericTypeVariable) && (classLiteral = JavaElementFactory.newClassLiteral(((Expression)tree).getType(), tree instanceof J.FieldAccess)) != null && (castMethod = (classType = ((JavaType.Parameterized)classLiteral.getType()).getType()).getMethods().stream().filter(m -> m.getName().equals("cast")).findFirst()).isPresent()) {
                    J.MemberReference updated = JavaElementFactory.newInstanceMethodReference((Expression)classLiteral, castMethod.get(), lambda.getType()).withPrefix(lambda.getPrefix());
                    this.doAfterVisit((TreeVisitor)((ImportService)this.service(ImportService.class)).shortenFullyQualifiedTypeReferencesIn((J)updated));
                    return updated;
                }
                return l;
            }
            String code = "";
            if (body instanceof J.Binary) {
                J.Binary binary = (J.Binary)body;
                if ((binary.getOperator() == J.Binary.Type.Equal || binary.getOperator() == J.Binary.Type.NotEqual) && this.isNullCheck((J)binary.getLeft(), (J)binary.getRight()) || this.isNullCheck((J)binary.getRight(), (J)binary.getLeft())) {
                    code = J.Binary.Type.Equal == binary.getOperator() ? "java.util.Objects::isNull" : "java.util.Objects::nonNull";
                    J updated = JavaTemplate.builder((String)code).contextSensitive().build().apply(this.getCursor(), l.getCoordinates().replace(), new Object[0]);
                    this.doAfterVisit((TreeVisitor)((ImportService)this.service(ImportService.class)).shortenFullyQualifiedTypeReferencesIn(updated));
                    return updated;
                }
            } else if (body instanceof MethodCall) {
                MethodCall method = (MethodCall)body;
                if (method instanceof J.NewClass) {
                    J.NewClass nc = (J.NewClass)method;
                    if (nc.getBody() != null) {
                        return l;
                    }
                    if (ReplaceLambdaWithMethodReference.isAMethodInvocationArgument(l, this.getCursor()) && nc.getType() instanceof JavaType.Class) {
                        boolean hasMultipleConstructors;
                        JavaType.Class clazz = (JavaType.Class)nc.getType();
                        boolean bl = hasMultipleConstructors = clazz.getMethods().stream().filter(JavaType.Method::isConstructor).count() > 1L;
                        if (hasMultipleConstructors) {
                            return l;
                        }
                    }
                } else if (method instanceof J.MemberReference) {
                    return l;
                }
                if (method.getMethodType() == null || this.hasSelectWithPotentialSideEffects(method) || this.hasSelectWhoseReferenceMightChange(method) || !this.methodArgumentsMatchLambdaParameters(method, lambda)) {
                    return l;
                }
                JavaType.Method methodType = method.getMethodType();
                if (methodType != null && !this.isMethodReferenceAmbiguous(methodType)) {
                    Expression select;
                    Expression expression = select = method instanceof J.MethodInvocation ? ((J.MethodInvocation)method).getSelect() : null;
                    if (methodType.hasFlags(new Flag[]{Flag.Static}) || this.methodSelectMatchesFirstLambdaParameter(method, lambda)) {
                        if (method.getType() instanceof JavaType.Parameterized) {
                            if (((JavaType.Parameterized)method.getType()).getTypeParameters().stream().anyMatch(JavaType.GenericTypeVariable.class::isInstance)) {
                                return l;
                            }
                        }
                        J.MemberReference updated = JavaElementFactory.newStaticMethodReference(methodType, true, lambda.getType()).withPrefix(lambda.getPrefix());
                        this.doAfterVisit((TreeVisitor)((ImportService)this.service(ImportService.class)).shortenFullyQualifiedTypeReferencesIn((J)updated));
                        return updated;
                    }
                    if (method instanceof J.NewClass) {
                        TypeTree clazz = ((J.NewClass)method).getClazz();
                        clazz = clazz instanceof J.ParameterizedType ? ((J.ParameterizedType)clazz).getClazz() : clazz;
                        return JavaElementFactory.newInstanceMethodReference((Expression)clazz.withPrefix(Space.EMPTY), "new", methodType, lambda.getType()).withPrefix(lambda.getPrefix());
                    }
                    if (select != null) {
                        return JavaElementFactory.newInstanceMethodReference(select, methodType, lambda.getType()).withPrefix(lambda.getPrefix());
                    }
                    Cursor owner = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.NewClass && ((J.NewClass)is).getBody() != null || is instanceof J.Lambda);
                    return JavaElementFactory.newInstanceMethodReference((Expression)JavaElementFactory.newThis(((TypedTree)owner.getValue()).getType()), methodType, lambda.getType()).withPrefix(lambda.getPrefix());
                }
            }
            return l;
        }

        private boolean hasSelectWithPotentialSideEffects(MethodCall method) {
            return method instanceof J.MethodInvocation && ((J.MethodInvocation)method).getSelect() instanceof MethodCall;
        }

        private boolean hasSelectWhoseReferenceMightChange(MethodCall method) {
            if (method instanceof J.MethodInvocation) {
                Expression select = ((J.MethodInvocation)method).getSelect();
                if (select instanceof J.Identifier) {
                    JavaType.Variable fieldType = ((J.Identifier)select).getFieldType();
                    return fieldType != null && fieldType.getOwner() instanceof JavaType.Class && !fieldType.hasFlags(new Flag[]{Flag.Final});
                }
                if (select instanceof J.FieldAccess) {
                    JavaType.Variable fieldType = ((J.FieldAccess)select).getName().getFieldType();
                    return fieldType != null && fieldType.getOwner() instanceof JavaType.Class && !fieldType.hasFlags(new Flag[]{Flag.Final});
                }
            }
            return false;
        }

        private boolean methodArgumentsMatchLambdaParameters(MethodCall method, J.Lambda lambda) {
            JavaType.Method methodType = method.getMethodType();
            if (methodType == null) {
                return false;
            }
            boolean static_ = methodType.hasFlags(new Flag[]{Flag.Static});
            List<Expression> methodArgs = ReplaceLambdaWithMethodReferenceJavaVisitor.getMethodArguments(method);
            List<J.VariableDeclarations.NamedVariable> lambdaParameters = ReplaceLambdaWithMethodReferenceJavaVisitor.getLambdaParameters(lambda);
            if (methodArgs.isEmpty() && lambdaParameters.isEmpty()) {
                return true;
            }
            if (!static_ && this.methodSelectMatchesFirstLambdaParameter(method, lambda)) {
                methodArgs.add(0, ((J.MethodInvocation)method).getSelect());
            }
            if (methodArgs.size() != lambdaParameters.size()) {
                return false;
            }
            for (int i = 0; i < lambdaParameters.size(); ++i) {
                JavaType.Variable lambdaParam = lambdaParameters.get(i).getVariableType();
                if (!(methodArgs.get(i) instanceof J.Identifier)) {
                    return false;
                }
                JavaType.Variable methodArgument = ((J.Identifier)methodArgs.get(i)).getFieldType();
                if (lambdaParam == methodArgument) continue;
                return false;
            }
            return true;
        }

        private static List<Expression> getMethodArguments(MethodCall method) {
            ArrayList<Expression> list = new ArrayList<Expression>();
            if (method instanceof J.MethodInvocation) {
                for (Expression a : ((J.MethodInvocation)method).getPadding().getArguments().getElements()) {
                    if (a instanceof J.Empty) continue;
                    list.add(a);
                }
            } else if (method instanceof J.NewClass) {
                for (Expression a : ((J.NewClass)method).getPadding().getArguments().getElements()) {
                    if (a instanceof J.Empty) continue;
                    list.add(a);
                }
            } else {
                for (Expression a : method.getArguments()) {
                    if (a instanceof J.Empty) continue;
                    list.add(a);
                }
            }
            return list;
        }

        private static List<J.VariableDeclarations.NamedVariable> getLambdaParameters(J.Lambda lambda) {
            ArrayList<J.VariableDeclarations.NamedVariable> list = new ArrayList<J.VariableDeclarations.NamedVariable>();
            for (J j : lambda.getParameters().getParameters()) {
                if (!(j instanceof J.VariableDeclarations)) continue;
                J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)j).getVariables().get(0);
                list.add(namedVariable);
            }
            return list;
        }

        private boolean methodSelectMatchesFirstLambdaParameter(MethodCall method, J.Lambda lambda) {
            if (!(method instanceof J.MethodInvocation) || !(((J.MethodInvocation)method).getSelect() instanceof J.Identifier) || lambda.getParameters().getParameters().isEmpty() || !(lambda.getParameters().getParameters().get(0) instanceof J.VariableDeclarations)) {
                return false;
            }
            J.VariableDeclarations firstLambdaParameter = (J.VariableDeclarations)lambda.getParameters().getParameters().get(0);
            return ((J.Identifier)((J.MethodInvocation)method).getSelect()).getFieldType() == ((J.VariableDeclarations.NamedVariable)firstLambdaParameter.getVariables().get(0)).getVariableType();
        }

        private boolean isNullCheck(J j1, J j2) {
            return j1 instanceof J.Identifier && j2 instanceof J.Literal && "null".equals(((J.Literal)j2).getValueSource());
        }

        private boolean isMethodReferenceAmbiguous(JavaType.Method method) {
            int count = 0;
            for (JavaType.Method meth : method.getDeclaringType().getMethods()) {
                if (!meth.getName().equals(method.getName()) || meth.getName().equals("println") || meth.isConstructor() || ++count <= 1) continue;
                return true;
            }
            return false;
        }
    }

    private static class ReplaceLambdaWithMethodReferenceKotlinVisitor
    extends KotlinVisitor<ExecutionContext> {
        private ReplaceLambdaWithMethodReferenceKotlinVisitor() {
        }
    }
}

