/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

public class InlineVariable
extends Recipe {
    public String getDisplayName() {
        return "Inline variable";
    }

    public String getDescription() {
        return "Inline variables when they are immediately used to return or throw.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1488");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                String identReturned;
                J.Block bl = super.visitBlock(block, (Object)ctx);
                List statements = bl.getStatements();
                if (statements.size() > 1 && (identReturned = this.identReturned(statements)) != null && statements.get(statements.size() - 2) instanceof J.VariableDeclarations) {
                    J.VariableDeclarations varDec = (J.VariableDeclarations)statements.get(statements.size() - 2);
                    J.VariableDeclarations.NamedVariable identDefinition = (J.VariableDeclarations.NamedVariable)varDec.getVariables().get(0);
                    if (varDec.getLeadingAnnotations().isEmpty() && identDefinition.getSimpleName().equals(identReturned)) {
                        bl = bl.withStatements(ListUtils.map((List)statements, (i, statement) -> {
                            if (i == statements.size() - 2) {
                                return null;
                            }
                            if (i == statements.size() - 1) {
                                if (statement instanceof J.Return) {
                                    J.Return return_ = (J.Return)statement;
                                    return return_.withExpression((Expression)Objects.requireNonNull(identDefinition.getInitializer()).withPrefix(Objects.requireNonNull(return_.getExpression()).getPrefix())).withPrefix(varDec.getPrefix().withComments(ListUtils.concatAll((List)varDec.getComments(), (List)return_.getComments())));
                                }
                                if (statement instanceof J.Throw) {
                                    J.Throw thrown = (J.Throw)statement;
                                    return thrown.withException((Expression)Objects.requireNonNull(identDefinition.getInitializer()).withPrefix(Objects.requireNonNull(thrown.getException()).getPrefix())).withPrefix(varDec.getPrefix().withComments(ListUtils.concatAll((List)varDec.getComments(), (List)thrown.getComments())));
                                }
                            }
                            return statement;
                        }));
                    }
                }
                return bl;
            }

            @Nullable
            private String identReturned(List<Statement> stats) {
                J.Throw thr;
                Statement lastStatement = stats.get(stats.size() - 1);
                if (lastStatement instanceof J.Return) {
                    J.Return return_ = (J.Return)lastStatement;
                    Expression expression = return_.getExpression();
                    if (expression instanceof J.Identifier && !(expression.getType() instanceof JavaType.Array)) {
                        return ((J.Identifier)expression).getSimpleName();
                    }
                } else if (lastStatement instanceof J.Throw && (thr = (J.Throw)lastStatement).getException() instanceof J.Identifier) {
                    return ((J.Identifier)thr.getException()).getSimpleName();
                }
                return null;
            }
        };
    }
}

