/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.ExplicitInitializationStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.staticanalysis.ExplicitInitializationVisitor;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public class ExplicitInitialization
extends Recipe {
    public String getDisplayName() {
        return "Explicit initialization";
    }

    public String getDescription() {
        return "Checks if any class or object member is explicitly initialized to default for its type value:\n- `null` for object references\n- zero for numeric types and `char`\n- and `false` for `boolean`\nRemoves explicit initializations where they aren't necessary.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3052");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new KotlinFileChecker()), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    ExplicitInitializationStyle style = (ExplicitInitializationStyle)cu.getStyle(ExplicitInitializationStyle.class);
                    if (style == null) {
                        style = Checkstyle.explicitInitialization();
                    }
                    return (J)new ExplicitInitializationVisitor(style).visit((Tree)cu, ctx);
                }
                return (J)tree;
            }
        });
    }
}

