/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.ExplicitInitializationStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public final class ExplicitInitializationVisitor<P>
extends JavaIsoVisitor<P> {
    private static final AnnotationMatcher LOMBOK_VALUE = new AnnotationMatcher("@lombok.Value");
    private static final AnnotationMatcher LOMBOK_BUILDER_DEFAULT = new AnnotationMatcher("@lombok.Builder.Default");
    private final ExplicitInitializationStyle style;

    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.Literal literalInit;
        J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, p);
        Cursor variableDeclsCursor = this.getCursor().getParentTreeCursor();
        Cursor maybeBlockOrGType = variableDeclsCursor.getParentTreeCursor();
        if (maybeBlockOrGType.getParent() == null || maybeBlockOrGType.getParent().getParent() == null) {
            return v;
        }
        J maybeClassDecl = (J)maybeBlockOrGType.getParentTreeCursor().getValue();
        if (!(maybeClassDecl instanceof J.ClassDeclaration) || J.ClassDeclaration.Kind.Type.Class != ((J.ClassDeclaration)maybeClassDecl).getKind() || !(variableDeclsCursor.getValue() instanceof J.VariableDeclarations)) {
            return v;
        }
        J.ClassDeclaration clz = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
        if (clz != null) {
            if (clz.getAllAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)LOMBOK_VALUE).matches(arg_0))) {
                return v;
            }
        }
        JavaType.Primitive primitive = TypeUtils.asPrimitive((JavaType)variable.getType());
        JavaType.Array array = TypeUtils.asArray((JavaType)variable.getType());
        J.VariableDeclarations variableDecls = (J.VariableDeclarations)variableDeclsCursor.getValue();
        if (variableDecls.getAllAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)LOMBOK_BUILDER_DEFAULT).matches(arg_0))) {
            return v;
        }
        J.Literal literal = literalInit = variable.getInitializer() instanceof J.Literal ? (J.Literal)variable.getInitializer() : null;
        if (literalInit != null && !variableDecls.hasModifier(J.Modifier.Type.Final)) {
            if (TypeUtils.asFullyQualified((JavaType)variable.getType()) != null && JavaType.Primitive.Null.equals((Object)literalInit.getType())) {
                v = v.withInitializer(null);
            } else if (primitive != null && !Boolean.TRUE.equals(this.style.getOnlyObjectReferences())) {
                switch (primitive) {
                    case Boolean: {
                        if (literalInit.getValue() != Boolean.valueOf(false)) break;
                        v = v.withInitializer(null);
                        break;
                    }
                    case Char: {
                        if (!(literalInit.getValue() instanceof Character) || ((Character)literalInit.getValue()).charValue() != '\u0000') break;
                        v = v.withInitializer(null);
                        break;
                    }
                    case Int: 
                    case Long: 
                    case Short: {
                        if (!(literalInit.getValue() instanceof Number) || ((Number)literalInit.getValue()).intValue() != 0) break;
                        v = v.withInitializer(null);
                    }
                }
            } else if (array != null && JavaType.Primitive.Null.equals((Object)literalInit.getType())) {
                v = v.withInitializer(null).withDimensionsAfterName(ListUtils.map((List)v.getDimensionsAfterName(), (i, dim) -> i == 0 ? dim.withBefore(Space.EMPTY) : dim));
            }
        }
        return v;
    }

    public ExplicitInitializationVisitor(ExplicitInitializationStyle style) {
        this.style = style;
    }

    public ExplicitInitializationStyle getStyle() {
        return this.style;
    }

    public String toString() {
        return "ExplicitInitializationVisitor(style=" + this.getStyle() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplicitInitializationVisitor)) {
            return false;
        }
        ExplicitInitializationVisitor other = (ExplicitInitializationVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExplicitInitializationStyle this$style = this.getStyle();
        ExplicitInitializationStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExplicitInitializationVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ExplicitInitializationStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }
}

