/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.java.JavaFileChecker;

public class LambdaBlockToExpression
extends Recipe {
    public String getDisplayName() {
        return "Simplify lambda blocks to expressions";
    }

    public String getDescription() {
        return "Single-line statement lambdas returning a value can be replaced with expression lambdas.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new JavaFileChecker(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext executionContext) {
                List statements;
                J.Lambda l = super.visitLambda(lambda, (Object)executionContext);
                if (lambda.getBody() instanceof J.Block && (statements = ((J.Block)lambda.getBody()).getStatements()).size() == 1 && statements.get(0) instanceof J.Return) {
                    Space prefix = ((Statement)statements.get(0)).getPrefix();
                    if (prefix.getComments().isEmpty()) {
                        return l.withBody((J)((J.Return)statements.get(0)).getExpression());
                    }
                    return l.withBody(((J.Return)statements.get(0)).getExpression().withPrefix(prefix));
                }
                return l;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (LambdaBlockToExpression.hasLambdaArgument(method) && LambdaBlockToExpression.hasMethodOverloading(method)) {
                    return method;
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        });
    }

    private static boolean hasMethodOverloading(J.MethodInvocation method) {
        JavaType.Method methodType = method.getMethodType();
        return methodType != null && LambdaBlockToExpression.hasMethodOverloading(methodType);
    }

    static boolean hasMethodOverloading(JavaType.Method methodType) {
        String methodName = methodType.getName();
        return Optional.of(methodType).map(JavaType.Method::getDeclaringType).filter(JavaType.Class.class::isInstance).map(JavaType.Class.class::cast).map(JavaType.Class::getMethods).map(methods -> {
            int overloadingCount = 0;
            for (JavaType.Method dm : methods) {
                if (!dm.getName().equals(methodName) || ++overloadingCount <= 1) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    private static boolean hasLambdaArgument(J.MethodInvocation method) {
        boolean hasLambdaArgument = false;
        for (Expression arg : method.getArguments()) {
            if (!(arg instanceof J.Lambda)) continue;
            hasLambdaArgument = true;
            break;
        }
        return hasLambdaArgument;
    }
}

