/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.kotlin.marker.IsNullSafe;

public class SimplifyBooleanExpression
extends Recipe {
    public String getDisplayName() {
        return "Simplify boolean expression";
    }

    public String getDescription() {
        return "Checks for overly complicated boolean expressions, such as `if (b == true)`, `b || true`, `!false`, etc.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1125");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SimplifyBooleanExpressionVisitor(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(super.visit(tree, ctx));
                    if (tree != cu) {
                        cu = (JavaSourceFile)SimplifyBooleanExpression.this.getVisitor().visitNonNull((Tree)cu, (Object)ctx);
                    }
                    return cu;
                }
                return super.visit(tree, ctx);
            }

            protected boolean shouldSimplifyEqualsOn(@Nullable J j) {
                if (j == null) {
                    return true;
                }
                if (j instanceof J.MethodInvocation) {
                    J.MethodInvocation m = (J.MethodInvocation)j;
                    return !m.getMarkers().findFirst(IsNullSafe.class).isPresent();
                }
                return true;
            }
        };
    }

    public boolean causesAnotherCycle() {
        return true;
    }
}

