/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class UseListSort
extends Recipe {
    public String getDisplayName() {
        return "Replace invocations of `Collections#sort(List, Comparator)` with `List#sort(Comparator)`";
    }

    public String getDescription() {
        return "The `java.util.Collections#sort(..)` implementation defers to the `java.util.List#sort(Comparator)`, replaced it with the `java.util.List#sort(Comparator)` implementation for better readability.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher collectionsSort = new MethodMatcher("java.util.Collections sort(..)");
        return Preconditions.check((TreeVisitor)new UsesMethod(collectionsSort), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
                if (collectionsSort.matches(mi)) {
                    this.updateCursor((Tree)mi);
                    this.maybeRemoveImport("java.util.Collections");
                    if (mi.getArguments().size() == 1) {
                        return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(java.util.List)}.sort(null)").imports(new String[]{"java.util.List"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)});
                    }
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(java.util.List)}.sort(#{any(java.util.Comparator)})").imports(new String[]{"java.util.List", "java.util.Comparator"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), mi.getArguments().get(1)});
                }
                return mi;
            }
        });
    }
}

