/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import lombok.Generated;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.StatementVisitorAdapter;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.jspecify.annotations.Nullable;
import org.openrewrite.PathUtils;
import org.openrewrite.SourceFile;
import org.openrewrite.sql.table.DatabaseColumnsUsed;

public class SqlDetector {
    private static final Pattern SIMPLE_SQL_HEURISTIC = Pattern.compile("SELECT|UPDATE|DELETE|INSERT", 2);
    private static final Pattern SIMPLE_DDL_HEURISTIC = Pattern.compile("CREATE|ALTER|DROP|TRUNCATE", 2);

    public List<DatabaseColumnsUsed.Row> rows(final SourceFile sourceFile, final @Nullable String commitHash, final int lineNumber, @Nullable String maybeSql) {
        Statement statement;
        if (!this.probablySql(maybeSql)) {
            return Collections.emptyList();
        }
        final AtomicReference rows = new AtomicReference();
        try {
            statement = CCJSqlParserUtil.parse((String)maybeSql);
        }
        catch (JSQLParserException e) {
            return Collections.emptyList();
        }
        StatementVisitorAdapter statementVisitor = new StatementVisitorAdapter(){
            final Stack<DatabaseColumnsUsed.Operation> operation = new Stack();
            final Stack<String> table = new Stack();

            public void visit(Select select) {
                this.operation.push(DatabaseColumnsUsed.Operation.SELECT);
                select.accept((SelectVisitor)new SelectVisitorAdapter(){

                    public void visit(PlainSelect plainSelect) {
                        if (plainSelect.getFromItem() instanceof Table) {
                            Table t = (Table)plainSelect.getFromItem();
                            table.push(t.getName());
                            for (SelectItem selectItem : plainSelect.getSelectItems()) {
                                selectItem.accept((SelectItemVisitor)new ColumnDetector(rows, sourceFile, lineNumber, commitHash, operation.peek(), table.peek()));
                            }
                            table.pop();
                        }
                        super.visit(plainSelect);
                    }
                });
                this.operation.pop();
            }

            public void visit(Update update) {
                this.operation.push(DatabaseColumnsUsed.Operation.UPDATE);
                Table t = update.getTable();
                this.table.push(t.getName());
                for (UpdateSet set : update.getUpdateSets()) {
                    for (Column column : set.getColumns()) {
                        column.accept((ExpressionVisitor)new ColumnDetector(rows, sourceFile, lineNumber, commitHash, this.operation.peek(), this.table.peek()));
                    }
                }
                this.table.pop();
                this.operation.pop();
            }

            public void visit(Delete delete) {
                this.operation.push(DatabaseColumnsUsed.Operation.DELETE);
                for (Table table : delete.getTables()) {
                    SqlDetector.addRow(rows, new DatabaseColumnsUsed.Row(PathUtils.separatorsToUnix((String)sourceFile.getSourcePath().toString()), lineNumber, commitHash, this.operation.peek(), table.getName(), null));
                }
                if (delete.getTable() != null) {
                    SqlDetector.addRow(rows, new DatabaseColumnsUsed.Row(PathUtils.separatorsToUnix((String)sourceFile.getSourcePath().toString()), lineNumber, commitHash, this.operation.peek(), delete.getTable().getName(), null));
                }
                this.operation.pop();
            }
        };
        statement.accept((StatementVisitor)statementVisitor);
        return rows.get() == null ? Collections.emptyList() : (List)rows.get();
    }

    private boolean probablySql(@Nullable String maybeSql) {
        return maybeSql != null && SIMPLE_SQL_HEURISTIC.matcher(maybeSql).find();
    }

    private boolean probablyDdl(@Nullable String maybeDdl) {
        return maybeDdl != null && SIMPLE_DDL_HEURISTIC.matcher(maybeDdl).find();
    }

    public boolean isSql(@Nullable String maybeSql) {
        if (this.probablySql(maybeSql) || this.probablyDdl(maybeSql)) {
            try {
                for (String sql : maybeSql.split(";")) {
                    CCJSqlParserUtil.parse((String)sql);
                }
                return true;
            }
            catch (JSQLParserException jSQLParserException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void addRow(AtomicReference<List<DatabaseColumnsUsed.Row>> rows, DatabaseColumnsUsed.Row row) {
        rows.getAndUpdate(acc -> {
            List rs = acc == null ? new ArrayList() : acc;
            rs.add(row);
            return rs;
        });
    }

    private static final class ColumnDetector
    extends ExpressionVisitorAdapter {
        private final AtomicReference<List<DatabaseColumnsUsed.Row>> rows;
        private final SourceFile sourceFile;
        private final int lineNumber;
        private final @Nullable String commitHash;
        private final DatabaseColumnsUsed.Operation operation;
        private final String table;

        public void visit(AllColumns columns) {
            this.addRowForColumnName(columns.toString());
        }

        public void visit(Column column) {
            this.addRowForColumnName(column.getColumnName());
        }

        private void addRowForColumnName(String columnName) {
            SqlDetector.addRow(this.rows, new DatabaseColumnsUsed.Row(PathUtils.separatorsToUnix((String)this.sourceFile.getSourcePath().toString()), this.lineNumber, this.commitHash, this.operation, this.table, columnName));
        }

        @Generated
        public ColumnDetector(AtomicReference<List<DatabaseColumnsUsed.Row>> rows, SourceFile sourceFile, int lineNumber, @Nullable String commitHash, DatabaseColumnsUsed.Operation operation, String table) {
            this.rows = rows;
            this.sourceFile = sourceFile;
            this.lineNumber = lineNumber;
            this.commitHash = commitHash;
            this.operation = operation;
            this.table = table;
        }

        @Generated
        public AtomicReference<List<DatabaseColumnsUsed.Row>> getRows() {
            return this.rows;
        }

        @Generated
        public SourceFile getSourceFile() {
            return this.sourceFile;
        }

        @Generated
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Generated
        public @Nullable String getCommitHash() {
            return this.commitHash;
        }

        @Generated
        public DatabaseColumnsUsed.Operation getOperation() {
            return this.operation;
        }

        @Generated
        public String getTable() {
            return this.table;
        }

        @Generated
        public String toString() {
            return "SqlDetector.ColumnDetector(rows=" + this.getRows() + ", sourceFile=" + this.getSourceFile() + ", lineNumber=" + this.getLineNumber() + ", commitHash=" + this.getCommitHash() + ", operation=" + (Object)((Object)this.getOperation()) + ", table=" + this.getTable() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnDetector)) {
                return false;
            }
            ColumnDetector other = (ColumnDetector)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.getLineNumber() != other.getLineNumber()) {
                return false;
            }
            AtomicReference<List<DatabaseColumnsUsed.Row>> this$rows = this.getRows();
            AtomicReference<List<DatabaseColumnsUsed.Row>> other$rows = other.getRows();
            if (this$rows == null ? other$rows != null : !this$rows.equals(other$rows)) {
                return false;
            }
            SourceFile this$sourceFile = this.getSourceFile();
            SourceFile other$sourceFile = other.getSourceFile();
            if (this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile)) {
                return false;
            }
            String this$commitHash = this.getCommitHash();
            String other$commitHash = other.getCommitHash();
            if (this$commitHash == null ? other$commitHash != null : !this$commitHash.equals(other$commitHash)) {
                return false;
            }
            DatabaseColumnsUsed.Operation this$operation = this.getOperation();
            DatabaseColumnsUsed.Operation other$operation = other.getOperation();
            if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            return !(this$table == null ? other$table != null : !this$table.equals(other$table));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColumnDetector;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLineNumber();
            AtomicReference<List<DatabaseColumnsUsed.Row>> $rows = this.getRows();
            result = result * 59 + ($rows == null ? 43 : $rows.hashCode());
            SourceFile $sourceFile = this.getSourceFile();
            result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
            String $commitHash = this.getCommitHash();
            result = result * 59 + ($commitHash == null ? 43 : $commitHash.hashCode());
            DatabaseColumnsUsed.Operation $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            return result;
        }
    }
}

