/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.reactive.reactor;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ReactorProcessorCacheToSinkRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace various `Processor.cache` calls with their `Sinks` equivalent";
    }

    public String getDescription() {
        return "As of 3.5 Processors are deprecated and Sinks are preferred.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ReplayProcessorCacheToSinkRecipe(), new ReplayProcessorCacheDefaultToSinkRecipe()});
    }

    @NullMarked
    public static class ReplayProcessorCacheToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.cacheLast()` with `Sinks.many().replay().latest()`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.cacheLast();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate sinkAfter = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().latest();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.createBefore.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        return this.embed(this.sinkAfter.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor cacheLast(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplayProcessorCacheDefaultToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.cacheLast()` with `Sinks.many().replay().latest()`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.cacheLastOrDefault(#{value:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate sinkAfter = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().latestOrDefault(#{value:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.createBefore.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        return this.embed(this.sinkAfter.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor cacheLastOrDefault(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

