/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeAnnotationAttributeName;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.openapi.swagger.AnnotationUtils;

public class MigrateApiModelToSchema
extends Recipe {
    private static final String API_MODEL_FQN = "io.swagger.annotations.ApiModel";
    private static final String SCHEMA_FQN = "io.swagger.v3.oas.annotations.media.Schema";
    private static final AnnotationMatcher API_MODEL_MATCHER = new AnnotationMatcher("io.swagger.annotations.ApiModel");
    private static final AnnotationMatcher SCHEMA_MATCHER = new AnnotationMatcher("io.swagger.v3.oas.annotations.media.Schema");

    public String getDisplayName() {
        return "Migrate from `@ApiModel` to `@Schema`";
    }

    public String getDescription() {
        return "Converts the `@ApiModel` annotation to `@Schema` and converts the \"value\" attribute to \"name\".";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(API_MODEL_FQN, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                if (this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.ClassDeclaration) {
                    annotation = super.visitAnnotation(annotation, (Object)ctx);
                    if (API_MODEL_MATCHER.matches(annotation)) {
                        this.doAfterVisit(new ChangeAnnotationAttributeName(MigrateApiModelToSchema.API_MODEL_FQN, "value", "name").getVisitor());
                        this.doAfterVisit(new ChangeType(MigrateApiModelToSchema.API_MODEL_FQN, MigrateApiModelToSchema.SCHEMA_FQN, Boolean.valueOf(true)).getVisitor());
                        Map<String, J.Assignment> annotationAssignments = AnnotationUtils.extractArgumentAssignments(annotation);
                        if (annotationAssignments.containsKey("value")) {
                            J.Assignment value = annotationAssignments.remove("value");
                            annotationAssignments.put("name", value.withVariable((Expression)((J.Identifier)value.getVariable()).withSimpleName("name")));
                        }
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, MigrateApiModelToSchema.API_MODEL_FQN, annotationAssignments);
                    } else if (SCHEMA_MATCHER.matches(annotation)) {
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, MigrateApiModelToSchema.SCHEMA_FQN, (Object)"USING SCHEMA ALREADY");
                    }
                }
                return annotation;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                Map annotationAssignments = (Map)this.getCursor().getMessage(MigrateApiModelToSchema.API_MODEL_FQN);
                if (annotationAssignments == null) {
                    return cd;
                }
                boolean schemaAnnotationAlreadyPresent = this.getCursor().getMessage(MigrateApiModelToSchema.SCHEMA_FQN) != null;
                List newLeading = ListUtils.map((List)cd.getLeadingAnnotations(), annotation -> {
                    if (schemaAnnotationAlreadyPresent && API_MODEL_MATCHER.matches(annotation)) {
                        return null;
                    }
                    if (SCHEMA_MATCHER.matches(annotation)) {
                        AnnotationUtils.extractArgumentAssignedExpressions(annotation).keySet().forEach(annotationAssignments::remove);
                        if (!annotationAssignments.isEmpty()) {
                            return (J.Annotation)this.autoFormat((J)annotation.withArguments(ListUtils.concatAll((List)annotation.getArguments(), new ArrayList(annotationAssignments.values()))), ctx);
                        }
                    }
                    return annotation;
                });
                return cd.withLeadingAnnotations(ListUtils.mapFirst((List)newLeading, annotation -> annotation.withPrefix(Space.EMPTY)));
            }
        });
    }
}

