/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeAnnotationAttributeName;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class MigrateApiToTag
extends Recipe {
    private static final String FQN_API = "io.swagger.annotations.Api";
    private static final String FQN_TAG = "io.swagger.v3.oas.annotations.tags.Tag";
    private static final String FQN_TAGS = "io.swagger.v3.oas.annotations.tags.Tags";
    @Language(value="java")
    private static final String TAGS_CLASS = "package io.swagger.v3.oas.annotations.tags;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.METHOD, ElementType.TYPE, ElementType.ANNOTATION_TYPE})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface Tags {\n    Tag[] value() default {};\n}";
    @Language(value="java")
    private static final String TAG_CLASS = "package io.swagger.v3.oas.annotations.tags;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.METHOD, ElementType.TYPE, ElementType.ANNOTATION_TYPE})\n@Retention(RetentionPolicy.RUNTIME)\n@Repeatable(Tags.class)\npublic @interface Tag {\n    String name();\n    String description() default \"\";\n}";

    public String getDisplayName() {
        return "Migrate from `@Api` to `@Tag`";
    }

    public String getDescription() {
        return "Converts `@Api` to `@Tag` annotation and converts the directly mappable attributes and removes the others.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(FQN_API, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final AnnotationMatcher apiMatcher = new AnnotationMatcher("io.swagger.annotations.Api");

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation ann = super.visitAnnotation(annotation, (Object)ctx);
                if (this.apiMatcher.matches(ann)) {
                    Map<String, Expression> annotationArgumentAssignments = this.extractAnnotationArgumentAssignments(ann);
                    if (annotationArgumentAssignments.get("tags") != null) {
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, MigrateApiToTag.FQN_API, annotationArgumentAssignments);
                        this.maybeRemoveImport(MigrateApiToTag.FQN_API);
                        return null;
                    }
                    this.doAfterVisit(new ChangeAnnotationAttributeName(MigrateApiToTag.FQN_API, "value", "name").getVisitor());
                    this.doAfterVisit(new ChangeType(MigrateApiToTag.FQN_API, MigrateApiToTag.FQN_TAG, Boolean.valueOf(true)).getVisitor());
                }
                return ann;
            }

            private Map<String, Expression> extractAnnotationArgumentAssignments(J.Annotation apiAnnotation) {
                if (apiAnnotation.getArguments() == null || apiAnnotation.getArguments().isEmpty() || apiAnnotation.getArguments().get(0) instanceof J.Empty) {
                    return Collections.emptyMap();
                }
                HashMap<String, Expression> map = new HashMap<String, Expression>();
                for (Expression expression : apiAnnotation.getArguments()) {
                    if (!(expression instanceof J.Assignment)) continue;
                    J.Assignment a = (J.Assignment)expression;
                    String simpleName = ((J.Identifier)a.getVariable()).getSimpleName();
                    map.put(simpleName, a.getAssignment());
                }
                return map;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.NewArray newArray;
                List initializer;
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                Map annotationArguments = (Map)this.getCursor().getMessage(MigrateApiToTag.FQN_API);
                if (annotationArguments == null) {
                    return cd;
                }
                Expression descriptionAssignment = (Expression)annotationArguments.get("description");
                Expression tagsAssignment = (Expression)annotationArguments.get("tags");
                cd = tagsAssignment instanceof J.NewArray ? ((initializer = Objects.requireNonNull((newArray = (J.NewArray)tagsAssignment).getInitializer())).size() == 1 ? this.addTagAnnotation(cd, (Expression)initializer.get(0), descriptionAssignment) : this.addTagsAnnotation(cd, initializer, descriptionAssignment)) : this.addTagAnnotation(cd, tagsAssignment, descriptionAssignment);
                return (J.ClassDeclaration)this.maybeAutoFormat((J)classDecl, (J)cd, (J)cd.getName(), ctx, this.getCursor().getParentTreeCursor());
            }

            private J.ClassDeclaration addTagsAnnotation(J.ClassDeclaration cd, List<Expression> tagsAssignments, @Nullable Expression descriptionAssignment) {
                StringBuilder template = new StringBuilder("@Tags({");
                ArrayList<Expression> templateArgs = new ArrayList<Expression>();
                for (Expression expression : tagsAssignments) {
                    if (!templateArgs.isEmpty()) {
                        template.append(",");
                    }
                    template.append("\n@Tag(name = #{any()}");
                    templateArgs.add(expression);
                    if (descriptionAssignment != null) {
                        template.append(", description = #{any()}");
                        templateArgs.add(descriptionAssignment);
                    }
                    template.append(")");
                }
                template.append("\n})");
                this.maybeAddImport(MigrateApiToTag.FQN_TAG);
                this.maybeAddImport(MigrateApiToTag.FQN_TAGS);
                return (J.ClassDeclaration)JavaTemplate.builder((String)template.toString()).imports(new String[]{MigrateApiToTag.FQN_TAGS, MigrateApiToTag.FQN_TAG}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{MigrateApiToTag.TAGS_CLASS, MigrateApiToTag.TAG_CLASS})).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), templateArgs.toArray());
            }

            private J.ClassDeclaration addTagAnnotation(J.ClassDeclaration cd, Expression tagsAssignment, @Nullable Expression descriptionAssignment) {
                StringBuilder template = new StringBuilder("@Tag(name = #{any()}");
                ArrayList<Expression> templateArgs = new ArrayList<Expression>();
                templateArgs.add(tagsAssignment);
                if (descriptionAssignment != null) {
                    template.append(", description = #{any()}");
                    templateArgs.add(descriptionAssignment);
                }
                template.append(")");
                this.maybeAddImport(MigrateApiToTag.FQN_TAG);
                return (J.ClassDeclaration)JavaTemplate.builder((String)template.toString()).imports(new String[]{MigrateApiToTag.FQN_TAG}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{MigrateApiToTag.TAGS_CLASS, MigrateApiToTag.TAG_CLASS})).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), templateArgs.toArray());
            }
        });
    }
}

