/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.nodejs.search;

import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Json;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.nodejs.search.IsPackageJson;
import org.openrewrite.nodejs.search.IsPackageLockJson;
import org.openrewrite.nodejs.table.NodeProjects;

public class FindNodeProjects
extends ScanningRecipe<AtomicBoolean> {
    private final transient NodeProjects nodeProjects = new NodeProjects((Recipe)this);

    public String getDisplayName() {
        return "Find Node.js projects";
    }

    public String getDescription() {
        return "Find Node.js projects and summarize data about them.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean hasPackageLock) {
        return Preconditions.check(new IsPackageLockJson(), (TreeVisitor)new JsonVisitor<ExecutionContext>(){

            public Json visitDocument(Json.Document document, ExecutionContext ctx) {
                hasPackageLock.set(true);
                return document;
            }
        });
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicBoolean hasPackageLock) {
        final JsonPathMatcher name = new JsonPathMatcher("$.name");
        final JsonPathMatcher version = new JsonPathMatcher("$.version");
        return Preconditions.check(new IsPackageJson(), (TreeVisitor)new JsonVisitor<ExecutionContext>(){

            public Json visitDocument(Json.Document document, ExecutionContext ctx) {
                hasPackageLock.set(true);
                super.visitDocument(document, (Object)ctx);
                FindNodeProjects.this.nodeProjects.insertRow(ctx, new NodeProjects.Row((String)this.getCursor().getMessage("name", (Object)""), (String)this.getCursor().getMessage("version", (Object)""), hasPackageLock.get()));
                return (Json)SearchResult.found((Tree)document);
            }

            public Json visitMember(Json.Member member, ExecutionContext ctx) {
                if (name.matches(this.getCursor())) {
                    String name2 = ((Json.Literal)member.getValue()).toString();
                    this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "name", (Object)name2);
                }
                if (version.matches(this.getCursor())) {
                    String version2 = ((Json.Literal)member.getValue()).toString();
                    this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "version", (Object)version2);
                }
                return member;
            }
        });
    }
}

