/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.ArrayList;
import java.util.StringJoiner;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;

public class UseListOf
extends Recipe {
    private static final MethodMatcher NEW_ARRAY_LIST = new MethodMatcher("java.util.ArrayList <constructor>()", true);
    private static final MethodMatcher LIST_ADD = new MethodMatcher("java.util.List add(..)", true);
    final String displayName = "Prefer `List.of(..)`";
    final String description = "Prefer `List.of(..)` instead of using `java.util.List#add(..)` in anonymous ArrayList initializers in Java 10 or higher. This recipe will not modify code where the List is later mutated since `List.of` returns an immutable list.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(10), new UsesMethod(NEW_ARRAY_LIST)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                Statement statement;
                J.NewClass n = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                J.Block body = n.getBody();
                if (NEW_ARRAY_LIST.matches((MethodCall)n) && body != null && body.getStatements().size() == 1 && (statement = (Statement)body.getStatements().get(0)) instanceof J.Block) {
                    ArrayList<Expression> args = new ArrayList<Expression>();
                    StringJoiner listOf = new StringJoiner(", ", "List.of(", ")");
                    for (Statement stat : ((J.Block)statement).getStatements()) {
                        if (!(stat instanceof J.MethodInvocation) || !LIST_ADD.matches((Expression)stat)) {
                            return n;
                        }
                        J.MethodInvocation add = (J.MethodInvocation)stat;
                        if (add.getArguments().size() != 1) {
                            return n;
                        }
                        args.add((Expression)add.getArguments().get(0));
                        listOf.add("#{any()}");
                    }
                    this.maybeRemoveImport("java.util.ArrayList");
                    this.maybeAddImport("java.util.List");
                    return JavaTemplate.builder((String)listOf.toString()).contextSensitive().imports(new String[]{"java.util.List"}).build().apply(this.updateCursor((Tree)n), n.getCoordinates().replace(), args.toArray());
                }
                return n;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

