/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.MaybeUsesImport;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class LombokValToFinalVar
extends Recipe {
    private static final String LOMBOK_VAL = "lombok.val";
    private static final String LOMBOK_VAR = "lombok.var";
    final String displayName = "Prefer `final var` over `lombok.val`";
    final String description = "Prefer the Java standard library's `final var` and `var` over third-party usage of Lombok's `lombok.val` and `lombok.var` in Java 10 or higher.";
    final Set<String> tags = Collections.singleton("lombok");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(LOMBOK_VAL, Boolean.valueOf(false)), new MaybeUsesImport(LOMBOK_VAR)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new LombokValToFinalVarVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    private static class LombokValToFinalVarVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private LombokValToFinalVarVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit compilationUnit, ExecutionContext ctx) {
            for (J.Import imp : compilationUnit.getImports()) {
                if (imp.isStatic() || !LombokValToFinalVar.LOMBOK_VAR.equals(imp.getTypeName()) || "*".equals(imp.getQualid().getSimpleName())) continue;
                this.maybeRemoveImport(LombokValToFinalVar.LOMBOK_VAR);
                break;
            }
            return super.visitCompilationUnit(compilationUnit, (Object)ctx);
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations mv, ExecutionContext ctx) {
            J.VariableDeclarations varDecls = super.visitVariableDeclarations(mv, (Object)ctx);
            if (TypeUtils.isOfClassType((JavaType)varDecls.getType(), (String)LombokValToFinalVar.LOMBOK_VAL) || varDecls.getTypeExpression() instanceof J.Identifier && "val".equals(((J.Identifier)varDecls.getTypeExpression()).getSimpleName())) {
                this.maybeRemoveImport(LombokValToFinalVar.LOMBOK_VAL);
                J.VariableDeclarations.NamedVariable nv = (J.VariableDeclarations.NamedVariable)mv.getVariables().get(0);
                if (nv.getInitializer() == null) {
                    TypeTree typeExpression = varDecls.getTypeExpression();
                    J.Identifier varType = new J.Identifier(Tree.randomId(), typeExpression.getPrefix(), typeExpression.getMarkers(), ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor()), "var", nv.getType(), null);
                    return varDecls.withTypeExpression((TypeTree)varType);
                }
                varDecls = (J.VariableDeclarations)JavaTemplate.builder((String)"final var #{} = #{any()};").contextSensitive().build().apply(this.updateCursor((Tree)varDecls), varDecls.getCoordinates().replace(), new Object[]{nv.getSimpleName(), nv.getInitializer()});
                varDecls = varDecls.withVariables(ListUtils.map((List)varDecls.getVariables(), namedVar -> namedVar.withInitializer((Expression)namedVar.getInitializer().withPrefix(nv.getInitializer().getPrefix()))));
            }
            return varDecls;
        }
    }
}

