/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.migrate.lang.NullCheck;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class IfElseIfConstructToSwitch
extends Recipe {
    private final String displayName = "If-else-if-else to switch";
    private final String description = "Replace if-else-if-else with switch statements. In order to be replaced with a switch, all conditions must be on the same variable and there must be at least three cases.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(21), Preconditions.not((TreeVisitor)new KotlinFileChecker()), Preconditions.not((TreeVisitor)new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitIf(J.If if_, ExecutionContext ctx) {
                J.Switch switch_ = new SwitchCandidate(if_, this.getCursor()).buildSwitchTemplate();
                if (switch_ != null) {
                    switch_ = new JavaIsoVisitor<ExecutionContext>(){

                        public J.Case visitCase(J.Case case_, ExecutionContext ctx) {
                            if (case_.getBody() == null) {
                                return case_;
                            }
                            if (case_.getBody() instanceof J.Block && ((J.Block)case_.getBody()).getStatements().isEmpty() && !((J.Block)case_.getBody()).getEnd().isEmpty()) {
                                return case_.withBody((J)((J.Block)case_.getBody()).withPrefix(Space.SINGLE_SPACE).withEnd(Space.EMPTY));
                            }
                            return case_.withBody(case_.getBody().withPrefix(Space.SINGLE_SPACE));
                        }
                    }.visitSwitch(switch_, (Object)ctx);
                    return super.visitSwitch(switch_, (Object)ctx);
                }
                return super.visitIf(if_, (Object)ctx);
            }
        });
    }

    @Generated
    public IfElseIfConstructToSwitch() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "IfElseIfConstructToSwitch(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IfElseIfConstructToSwitch)) {
            return false;
        }
        IfElseIfConstructToSwitch other = (IfElseIfConstructToSwitch)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof IfElseIfConstructToSwitch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class SwitchCandidate {
        private final Map<J.InstanceOf, Statement> patternMatchers = new LinkedHashMap<J.InstanceOf, Statement>();
        private @Nullable Expression nullCheckedParameter = null;
        private @Nullable Statement nullCheckedStatement = null;
        private @Nullable Statement else_ = null;
        private final Cursor cursor;
        private final J.If if_;
        private boolean potentialCandidate = true;

        private SwitchCandidate(J.If if_, Cursor cursor) {
            this.if_ = if_;
            this.cursor = cursor;
            Cursor parent = cursor.getParent(2);
            if (parent == null || parent.getValue() instanceof J.If.Else) {
                this.potentialCandidate = false;
                return;
            }
            J.If ifPart = if_;
            while (this.potentialCandidate && ifPart != null) {
                if (ifPart.getIfCondition().getTree() instanceof J.Binary) {
                    ifPart = this.handleNullCheck(ifPart, cursor);
                    continue;
                }
                if (ifPart.getIfCondition().getTree() instanceof J.InstanceOf) {
                    ifPart = this.handleInstanceOfCheck(ifPart);
                    continue;
                }
                this.potentialCandidate = false;
                return;
            }
            this.potentialCandidate = this.validatePotentialCandidate();
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.If handleNullCheck(J.If ifPart, Cursor cursor) {
            Optional nullCheck = NullCheck.Matcher.nullCheck().get((Tree)ifPart, cursor);
            if (nullCheck.isPresent()) {
                this.nullCheckedParameter = ((NullCheck)nullCheck.get()).getNullCheckedParameter();
                this.nullCheckedStatement = ((NullCheck)nullCheck.get()).whenNull();
                Statement elsePart = ((NullCheck)nullCheck.get()).whenNotNull();
                if (elsePart instanceof J.If) {
                    ifPart = (J.If)elsePart;
                } else {
                    this.else_ = elsePart;
                    ifPart = null;
                }
            } else {
                this.potentialCandidate = false;
            }
            return ifPart;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.If handleInstanceOfCheck(J.If ifPart) {
            this.patternMatchers.put((J.InstanceOf)ifPart.getIfCondition().getTree(), ifPart.getThenPart());
            J.If.Else elsePart = ifPart.getElsePart();
            if (elsePart != null && elsePart.getBody() instanceof J.If) {
                ifPart = (J.If)elsePart.getBody();
            } else {
                this.else_ = elsePart != null ? elsePart.getBody() : null;
                ifPart = null;
            }
            return ifPart;
        }

        private boolean validatePotentialCandidate() {
            Optional<Expression> switchOn = this.switchOn();
            if (!switchOn.isPresent() || !this.patternMatchers.keySet().stream().map(J.InstanceOf::getExpression).allMatch(it -> SemanticallyEqual.areEqual((J)((J)switchOn.get()), (J)it))) {
                return false;
            }
            if (this.patternMatchers.keySet().stream().anyMatch(instanceOf -> instanceOf.getPattern() == null)) {
                return false;
            }
            if (this.returns(this.nullCheckedStatement) || this.patternMatchers.values().stream().anyMatch(this::returns) || this.returns(this.else_)) {
                return false;
            }
            if (this.patternMatchers.keySet().stream().anyMatch(instanceOf -> {
                J clazz = instanceOf.getClazz();
                return !(clazz instanceof J.Identifier) && !(clazz instanceof J.FieldAccess) && !(clazz instanceof J.ArrayType) && !(clazz instanceof J.ParameterizedType);
            })) {
                return false;
            }
            boolean nullCaseInSwitch = this.nullCheckedParameter != null && SemanticallyEqual.areEqual((J)this.nullCheckedParameter, (J)((J)switchOn.get()));
            boolean hasLastElseBlock = this.else_ != null;
            return 3 <= this.patternMatchers.size() + (nullCaseInSwitch ? 1 : 0) + (hasLastElseBlock ? 1 : 0);
        }

        private boolean returns(@Nullable Statement statement) {
            return statement != null && ((AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

                public J.Return visitReturn(J.Return return_, AtomicBoolean atomicBoolean) {
                    atomicBoolean.set(true);
                    return return_;
                }
            }.reduce((Tree)statement, (Object)new AtomicBoolean(false))).get();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Switch buildSwitchTemplate() {
            Optional<Expression> switchOn = this.switchOn();
            if (!this.potentialCandidate || !switchOn.isPresent()) {
                return null;
            }
            Object[] arguments = new Object[2 + (this.nullCheckedParameter != null ? 1 : 0) + this.patternMatchers.size() * 3];
            arguments[0] = switchOn.get();
            StringBuilder switchBody = new StringBuilder("switch (#{any()}) {\n");
            int i = 1;
            if (this.nullCheckedParameter != null) {
                switchBody.append("case null -> #{any()};\n");
                arguments[i++] = this.getStatement(Objects.requireNonNull(this.nullCheckedStatement));
            }
            for (Map.Entry<J.InstanceOf, Statement> entry : this.patternMatchers.entrySet()) {
                J.InstanceOf instanceOf = entry.getKey();
                switchBody.append("case #{}#{} -> #{any()};\n");
                arguments[i++] = this.getClassName(instanceOf);
                arguments[i++] = this.getPattern(instanceOf);
                arguments[i++] = this.getStatement(entry.getValue());
            }
            switchBody.append("default -> #{any()};\n");
            arguments[i] = this.else_ != null ? this.getStatement(this.else_) : J.Block.createEmptyBlock();
            switchBody.append("}\n");
            return (J.Switch)JavaTemplate.apply((String)switchBody.toString(), (Cursor)this.cursor, (JavaCoordinates)this.if_.getCoordinates().replace(), (Object[])arguments).withPrefix(this.if_.getPrefix());
        }

        private Optional<Expression> switchOn() {
            return this.patternMatchers.keySet().stream().map(J.InstanceOf::getExpression).filter(e -> e instanceof J.FieldAccess || e instanceof J.Identifier).findAny();
        }

        private String getClassName(J.InstanceOf statement) {
            if (statement.getClazz() instanceof J.Identifier) {
                return ((J.Identifier)statement.getClazz()).getSimpleName();
            }
            return statement.getClazz().toString();
        }

        private String getPattern(J.InstanceOf statement) {
            if (statement.getPattern() instanceof J.Identifier) {
                return " " + ((J.Identifier)statement.getPattern()).getSimpleName();
            }
            return "";
        }

        private Statement getStatement(Statement statement) {
            Statement firstStatement;
            if (statement instanceof J.Block && ((J.Block)statement).getStatements().size() == 1 && ((firstStatement = (Statement)((J.Block)statement).getStatements().get(0)) instanceof Expression || firstStatement instanceof J.Throw)) {
                return firstStatement;
            }
            return statement;
        }
    }
}

