/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class DontOverfetchDto
extends Recipe {
    @Option(displayName="DTO type", description="The fully qualified name of the DTO.", example="animals.Dog")
    private final String dtoType;
    @Option(displayName="Data element", description="Replace the DTO as a method parameter when only this data element is used.", example="name")
    private final String dtoDataElement;
    private final String displayName = "Replace DTO method parameters with data elements";
    private final String description = "Replace method parameters that have DTOs with their data elements when only the specified data element is used.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dtoFields = new MethodMatcher(this.dtoType + " *(..)");
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                for (Map.Entry usesForArgument : ((Map)this.getCursor().getMessage("dtoDataUses", Collections.emptyMap())).entrySet()) {
                    String dtoVariableName = (String)usesForArgument.getKey();
                    Set allUses = (Set)usesForArgument.getValue();
                    if (allUses.size() != 1 || !((String)allUses.iterator().next()).equals(DontOverfetchDto.this.dtoDataElement)) continue;
                    AtomicReference memberTypeAtomic = new AtomicReference();
                    m = m.withParameters(ListUtils.map((List)m.getParameters(), p -> {
                        JavaType.FullyQualified dtoType;
                        J.VariableDeclarations v;
                        if (p instanceof J.VariableDeclarations && ((J.VariableDeclarations.NamedVariable)(v = (J.VariableDeclarations)p).getVariables().get(0)).getSimpleName().equals(dtoVariableName) && (dtoType = v.getTypeAsFullyQualified()) != null) {
                            for (JavaType.Variable member : dtoType.getMembers()) {
                                if (!member.getName().equals(DontOverfetchDto.this.dtoDataElement)) continue;
                                JavaType.FullyQualified memberType = TypeUtils.asFullyQualified((JavaType)member.getType());
                                memberTypeAtomic.set(memberType);
                                if (memberType == null) continue;
                                this.maybeRemoveImport(dtoType);
                                this.maybeAddImport(memberType);
                                return v.withType((JavaType)memberType).withTypeExpression(TypeTree.build((String)memberType.getFullyQualifiedName())).withVariables(ListUtils.map((List)v.getVariables(), nv -> {
                                    JavaType.Variable fieldType = nv.getName().getFieldType();
                                    return nv.withName(nv.getName().withSimpleName(DontOverfetchDto.this.dtoDataElement).withType((JavaType)memberType)).withType((JavaType)memberType).withVariableType(fieldType.withName(DontOverfetchDto.this.dtoDataElement).withOwner((JavaType)memberType));
                                }));
                            }
                        }
                        return p;
                    }));
                    m = (J.MethodDeclaration)new ReplaceWithDtoElement(dtoVariableName, (JavaType.FullyQualified)memberTypeAtomic.get()).visitNonNull((Tree)m, ctx, this.getCursor().getParentOrThrow());
                }
                return m;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Iterator methodDeclarations;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (dtoFields.matches((MethodCall)method) && (methodDeclarations = this.getCursor().getPathAsCursors(c -> c.getValue() instanceof J.MethodDeclaration)).hasNext() && method.getSelect() instanceof J.Identifier) {
                    String argumentName = ((J.Identifier)method.getSelect()).getSimpleName();
                    ((HashMap)((Cursor)methodDeclarations.next()).computeMessageIfAbsent("dtoDataUses", k -> new HashMap())).computeIfAbsent(argumentName, n -> new HashSet()).add(StringUtils.uncapitalize((String)method.getSimpleName().replaceAll("^get", "")));
                }
                return m;
            }
        };
    }

    @ConstructorProperties(value={"dtoType", "dtoDataElement"})
    @Generated
    public DontOverfetchDto(String dtoType, String dtoDataElement) {
        this.dtoType = dtoType;
        this.dtoDataElement = dtoDataElement;
    }

    @Generated
    public String getDtoType() {
        return this.dtoType;
    }

    @Generated
    public String getDtoDataElement() {
        return this.dtoDataElement;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DontOverfetchDto(dtoType=" + this.getDtoType() + ", dtoDataElement=" + this.getDtoDataElement() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DontOverfetchDto)) {
            return false;
        }
        DontOverfetchDto other = (DontOverfetchDto)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$dtoType = this.getDtoType();
        String other$dtoType = other.getDtoType();
        if (this$dtoType == null ? other$dtoType != null : !this$dtoType.equals(other$dtoType)) {
            return false;
        }
        String this$dtoDataElement = this.getDtoDataElement();
        String other$dtoDataElement = other.getDtoDataElement();
        if (this$dtoDataElement == null ? other$dtoDataElement != null : !this$dtoDataElement.equals(other$dtoDataElement)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DontOverfetchDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dtoType = this.getDtoType();
        result = result * 59 + ($dtoType == null ? 43 : $dtoType.hashCode());
        String $dtoDataElement = this.getDtoDataElement();
        result = result * 59 + ($dtoDataElement == null ? 43 : $dtoDataElement.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private class ReplaceWithDtoElement
    extends JavaVisitor<ExecutionContext> {
        private final String dtoVariableName;
        private final JavaType.FullyQualified memberType;

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (method.getSelect() instanceof J.Identifier && ((J.Identifier)method.getSelect()).getSimpleName().equals(this.dtoVariableName)) {
                return new J.Identifier(Tree.randomId(), method.getPrefix(), Markers.EMPTY, Collections.emptyList(), DontOverfetchDto.this.dtoDataElement, (JavaType)this.memberType, null);
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }

        @ConstructorProperties(value={"dtoVariableName", "memberType"})
        @Generated
        public ReplaceWithDtoElement(String dtoVariableName, JavaType.FullyQualified memberType) {
            this.dtoVariableName = dtoVariableName;
            this.memberType = memberType;
        }
    }
}

