/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class MigrateCollectionsSingletonSet
extends Recipe {
    private static final MethodMatcher SINGLETON_SET = new MethodMatcher("java.util.Collections singleton(..)", true);
    final String displayName = "Prefer `Set.of(..)`";
    final String description = "Prefer `Set.Of(..)` instead of using `Collections.singleton()` in Java 9 or higher.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(SINGLETON_SET)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (SINGLETON_SET.matches((MethodCall)m) && !J.Literal.isLiteralValue((Expression)((Expression)m.getArguments().get(0)), null)) {
                    this.maybeRemoveImport("java.util.Collections");
                    this.maybeAddImport("java.util.Set");
                    return JavaTemplate.builder((String)"Set.of(#{any()})").contextSensitive().imports(new String[]{"java.util.Set"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), new Object[]{m.getArguments().get(0)});
                }
                return m;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

