/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import lombok.Getter;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lombok.FieldAnnotator;
import org.openrewrite.java.migrate.lombok.LombokUtils;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class UseLombokGetter
extends Recipe {
    private final String displayName = "Convert getter methods to annotations";
    private final String description = "Convert trivial getter methods to `@Getter` annotations on their respective fields.";
    private final Set<String> tags = Collections.singleton("lombok");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (LombokUtils.isGetter(this.getCursor())) {
                    Expression returnExpression = ((J.Return)method.getBody().getStatements().get(0)).getExpression();
                    List onMethodAnnotations = ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor());
                    if (returnExpression instanceof J.Identifier && ((J.Identifier)returnExpression).getFieldType() != null) {
                        this.doAfterVisit((TreeVisitor)new FieldAnnotator(Getter.class, (JavaType)((J.Identifier)returnExpression).getFieldType(), LombokUtils.getAccessLevel(method), onMethodAnnotations));
                        return null;
                    }
                    if (returnExpression instanceof J.FieldAccess && ((J.FieldAccess)returnExpression).getName().getFieldType() != null) {
                        this.doAfterVisit((TreeVisitor)new FieldAnnotator(Getter.class, (JavaType)((J.FieldAccess)returnExpression).getName().getFieldType(), LombokUtils.getAccessLevel(method), onMethodAnnotations));
                        return null;
                    }
                }
                return method;
            }
        };
    }

    @Generated
    public UseLombokGetter() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseLombokGetter(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseLombokGetter)) {
            return false;
        }
        UseLombokGetter other = (UseLombokGetter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UseLombokGetter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }
}

