/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.lombok.LombokUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class AdoptLombokSetterMethodNames
extends ScanningRecipe<List<RenameRecord>> {
    private static final String DO_NOT_RENAME = "DO_NOT_RENAME";
    private final String displayName = "Rename setter methods to fit Lombok";
    private final String description = "Rename methods that are effectively setter to the name Lombok would give them.\nLimitations:\n - If two methods in a class are effectively the same setter then one's name will be corrected and the others name will be left as it is.\n - If the correct name for a method is already taken by another method then the name will not be corrected.\n - Method name swaps or circular renaming within a class cannot be performed because the names block each other.\nE.g. `int getFoo() { return ba; } int getBa() { return foo; }` stays as it is.";

    public List<RenameRecord> getInitialValue(ExecutionContext ctx) {
        return new ArrayList<RenameRecord>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final List<RenameRecord> renameRecords) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                Set declaredMethods = cu.getTypesInUse().getDeclaredMethods();
                ArrayList<String> existingMethodNames = new ArrayList<String>();
                for (JavaType.Method method : declaredMethods) {
                    existingMethodNames.add(method.getName());
                }
                this.getCursor().putMessage(AdoptLombokSetterMethodNames.DO_NOT_RENAME, existingMethodNames);
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                JavaType.Variable fieldType;
                if (method.getMethodType() == null || method.getBody() == null || !LombokUtils.isEffectivelySetter(method) || TypeUtils.isOverride((JavaType.Method)method.getMethodType())) {
                    return method;
                }
                Expression variable = ((J.Assignment)method.getBody().getStatements().get(0)).getVariable();
                if (variable instanceof J.FieldAccess) {
                    fieldType = ((J.FieldAccess)variable).getName().getFieldType();
                } else if (variable instanceof J.Identifier) {
                    fieldType = ((J.Identifier)variable).getFieldType();
                } else {
                    return method;
                }
                String expectedMethodName = LombokUtils.deriveSetterMethodName(fieldType);
                if (expectedMethodName.equals(method.getSimpleName())) {
                    return method;
                }
                List doNotRename = (List)this.getCursor().getNearestMessage(AdoptLombokSetterMethodNames.DO_NOT_RENAME);
                assert (doNotRename != null);
                if (doNotRename.contains(expectedMethodName)) {
                    return method;
                }
                renameRecords.add(new RenameRecord(MethodMatcher.methodPattern((J.MethodDeclaration)method), expectedMethodName));
                doNotRename.remove(method.getSimpleName());
                doNotRename.add(expectedMethodName);
                return method;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final List<RenameRecord> renameRecords) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                for (RenameRecord rr : renameRecords) {
                    tree = new ChangeMethodName(rr.methodPattern, rr.newMethodName, Boolean.valueOf(true), null).getVisitor().visit(tree, (Object)ctx);
                }
                return tree;
            }
        };
    }

    @Generated
    public AdoptLombokSetterMethodNames() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AdoptLombokSetterMethodNames(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdoptLombokSetterMethodNames)) {
            return false;
        }
        AdoptLombokSetterMethodNames other = (AdoptLombokSetterMethodNames)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AdoptLombokSetterMethodNames;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static final class RenameRecord {
        private final String methodPattern;
        private final String newMethodName;

        @ConstructorProperties(value={"methodPattern", "newMethodName"})
        @Generated
        public RenameRecord(String methodPattern, String newMethodName) {
            this.methodPattern = methodPattern;
            this.newMethodName = newMethodName;
        }

        @Generated
        public String getMethodPattern() {
            return this.methodPattern;
        }

        @Generated
        public String getNewMethodName() {
            return this.newMethodName;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameRecord)) {
                return false;
            }
            RenameRecord other = (RenameRecord)o;
            String this$methodPattern = this.getMethodPattern();
            String other$methodPattern = other.getMethodPattern();
            if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
                return false;
            }
            String this$newMethodName = this.getNewMethodName();
            String other$newMethodName = other.getNewMethodName();
            return !(this$newMethodName == null ? other$newMethodName != null : !this$newMethodName.equals(other$newMethodName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $methodPattern = this.getMethodPattern();
            result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
            String $newMethodName = this.getNewMethodName();
            result = result * 59 + ($newMethodName == null ? 43 : $newMethodName.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AdoptLombokSetterMethodNames.RenameRecord(methodPattern=" + this.getMethodPattern() + ", newMethodName=" + this.getNewMethodName() + ")";
        }
    }
}

