/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.logging;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class MigrateLogRecordSetMillisToSetInstant
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.util.logging.LogRecord setMillis(long)");
    final String displayName = "Use `LogRecord#setInstant(Instant)`";
    final String description = "Use `LogRecord#setInstant(Instant)` instead of the deprecated `LogRecord#setMillis(long)` in Java 9 or higher.";
    final Set<String> tags = Collections.singleton("deprecated");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(MATCHER)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = method;
                if (MATCHER.matches((MethodCall)m)) {
                    m = m.withName(m.getName().withSimpleName("setInstant"));
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"Instant.ofEpochMilli(#{any(long)})").imports(new String[]{"java.time.Instant"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0)});
                    this.maybeAddImport("java.time.Instant");
                }
                return super.visitMethodInvocation(m, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

