/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Collections;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class SwitchCaseEnumGuardToLabel
extends Recipe {
    private final String displayName = "Use switch cases labels for enums";
    private final String description = "Use switch case labels when a guard is checking equality with an enum.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(21), Preconditions.not((TreeVisitor)new KotlinFileChecker()), Preconditions.not((TreeVisitor)new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Case visitCase(J.Case case_, ExecutionContext ctx) {
                Expression guardedEnum;
                J.Case visitedCase = super.visitCase(case_, (Object)ctx);
                J.VariableDeclarations.NamedVariable label = this.getCreatedLabelVariable(visitedCase);
                if (label == null) {
                    return visitedCase;
                }
                JavaType type = label.getType();
                if (type instanceof JavaType.Class && ((JavaType.Class)type).getKind() == JavaType.FullyQualified.Kind.Enum && (guardedEnum = this.getGuardedEnum(visitedCase, label)) != null) {
                    J modifiedBody = (J)this.enumReferencesToEnumValue(label.getSimpleName(), guardedEnum).visit((Tree)visitedCase.getBody(), (Object)ctx);
                    return visitedCase.withGuard(null).withCaseLabels(Collections.singletonList(guardedEnum.withPrefix(((J)visitedCase.getCaseLabels().get(0)).getPrefix()))).withBody(modifiedBody);
                }
                return visitedCase;
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.VariableDeclarations.NamedVariable getCreatedLabelVariable(J.Case case_) {
                if (case_.getCaseLabels().size() != 1 || !(case_.getCaseLabels().get(0) instanceof J.VariableDeclarations)) {
                    return null;
                }
                J.VariableDeclarations decl = (J.VariableDeclarations)case_.getCaseLabels().get(0);
                if (decl.getVariables().size() != 1) {
                    return null;
                }
                return (J.VariableDeclarations.NamedVariable)decl.getVariables().get(0);
            }

            private @Nullable Expression getGuardedEnum(J.Case case_, J.VariableDeclarations.NamedVariable label) {
                J.Binary binaryGuard;
                Expression guard = case_.getGuard();
                if (guard == null) {
                    return null;
                }
                Expression select = null;
                Expression equalTo = null;
                if (guard instanceof J.MethodInvocation) {
                    J.MethodInvocation methodGuard = (J.MethodInvocation)guard;
                    if ("equals".equals(methodGuard.getSimpleName()) && methodGuard.getArguments().size() == 1) {
                        select = methodGuard.getSelect();
                        equalTo = (Expression)methodGuard.getArguments().get(0);
                    }
                } else if (guard instanceof J.Binary && J.Binary.Type.Equal == (binaryGuard = (J.Binary)guard).getOperator()) {
                    select = binaryGuard.getLeft();
                    equalTo = binaryGuard.getRight();
                }
                if ((select instanceof J.FieldAccess || select instanceof J.Identifier) && equalTo instanceof J.Identifier && label.getName().getSimpleName().equals(((J.Identifier)equalTo).getSimpleName())) {
                    return select;
                }
                if ((equalTo instanceof J.FieldAccess || equalTo instanceof J.Identifier) && select instanceof J.Identifier && label.getName().getSimpleName().equals(((J.Identifier)select).getSimpleName())) {
                    return equalTo;
                }
                return null;
            }

            private JavaVisitor<ExecutionContext> enumReferencesToEnumValue(final String name, final Expression enumReference) {
                return new JavaVisitor<ExecutionContext>(){

                    public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
                        J.Identifier identifier = (J.Identifier)super.visitIdentifier(ident, (Object)ctx);
                        if (identifier.getSimpleName().equals(name) && TypeUtils.isOfType((JavaType)identifier.getType(), (JavaType)enumReference.getType())) {
                            return enumReference.withPrefix(identifier.getPrefix());
                        }
                        return identifier;
                    }
                };
            }
        });
    }

    @Generated
    public SwitchCaseEnumGuardToLabel() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "SwitchCaseEnumGuardToLabel(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwitchCaseEnumGuardToLabel)) {
            return false;
        }
        SwitchCaseEnumGuardToLabel other = (SwitchCaseEnumGuardToLabel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof SwitchCaseEnumGuardToLabel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

