/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.ArrayList;
import java.util.StringJoiner;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;

public class UseMapOf
extends Recipe {
    private static final MethodMatcher NEW_HASH_MAP = new MethodMatcher("java.util.HashMap <constructor>()", true);
    private static final MethodMatcher MAP_PUT = new MethodMatcher("java.util.Map put(..)", true);
    final String displayName = "Prefer `Map.of(..)`";
    final String description = "Prefer `Map.of(..)` instead of using `java.util.Map#put(..)` in Java 10 or higher.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(10), new UsesMethod(NEW_HASH_MAP)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                Statement statement;
                J.NewClass n = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                J.Block body = n.getBody();
                if (NEW_HASH_MAP.matches((MethodCall)n) && body != null && body.getStatements().size() == 1 && (statement = (Statement)body.getStatements().get(0)) instanceof J.Block) {
                    ArrayList args = new ArrayList();
                    StringJoiner mapOf = new StringJoiner(", ", "Map.of(", ")");
                    for (Statement stat : ((J.Block)statement).getStatements()) {
                        if (!(stat instanceof J.MethodInvocation) || !MAP_PUT.matches((Expression)stat)) {
                            return n;
                        }
                        J.MethodInvocation put = (J.MethodInvocation)stat;
                        args.addAll(put.getArguments());
                        mapOf.add("#{any()}");
                        mapOf.add("#{any()}");
                    }
                    this.maybeRemoveImport("java.util.HashMap");
                    this.maybeAddImport("java.util.Map");
                    return JavaTemplate.builder((String)mapOf.toString()).contextSensitive().imports(new String[]{"java.util.Map"}).build().apply(this.updateCursor((Tree)n), n.getCoordinates().replace(), args.toArray());
                }
                return n;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

