/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.table;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class JavaVersionTable
extends DataTable<Row> {
    public JavaVersionTable(Recipe recipe) {
        super(recipe, "Java version table", "Records versions of Java in use");
    }

    public static final class Row {
        @Column(displayName="Source compatibility", description="The major version of Java used to compile the source code")
        private final String sourceVersion;
        @Column(displayName="Target compatibility", description="The major version of Java the bytecode is compiled to run on")
        private final String targetVersion;

        @ConstructorProperties(value={"sourceVersion", "targetVersion"})
        @Generated
        public Row(String sourceVersion, String targetVersion) {
            this.sourceVersion = sourceVersion;
            this.targetVersion = targetVersion;
        }

        @Generated
        public String getSourceVersion() {
            return this.sourceVersion;
        }

        @Generated
        public String getTargetVersion() {
            return this.targetVersion;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourceVersion = this.getSourceVersion();
            String other$sourceVersion = other.getSourceVersion();
            if (this$sourceVersion == null ? other$sourceVersion != null : !this$sourceVersion.equals(other$sourceVersion)) {
                return false;
            }
            String this$targetVersion = this.getTargetVersion();
            String other$targetVersion = other.getTargetVersion();
            return !(this$targetVersion == null ? other$targetVersion != null : !this$targetVersion.equals(other$targetVersion));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceVersion = this.getSourceVersion();
            result = result * 59 + ($sourceVersion == null ? 43 : $sourceVersion.hashCode());
            String $targetVersion = this.getTargetVersion();
            result = result * 59 + ($targetVersion == null ? 43 : $targetVersion.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JavaVersionTable.Row(sourceVersion=" + this.getSourceVersion() + ", targetVersion=" + this.getTargetVersion() + ")";
        }
    }
}

