/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.migrate.table.JavaVersionTable;
import org.openrewrite.java.tree.J;

public final class FindJavaVersion
extends Recipe {
    private final transient JavaVersionTable table = new JavaVersionTable(this);
    private final transient Set<JavaVersion> seen = new HashSet<JavaVersion>();
    private final String displayName = "Find Java versions in use";
    private final String description = "Finds Java versions in use.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                cu.getMarkers().findFirst(JavaVersion.class).filter(FindJavaVersion.this.seen::add).map(jv -> new JavaVersionTable.Row(Integer.toString(jv.getMajorVersion()), Integer.toString(jv.getMajorReleaseVersion()))).ifPresent(row -> FindJavaVersion.this.table.insertRow(ctx, row));
                return cu;
            }
        };
    }

    @Generated
    public FindJavaVersion() {
    }

    @Generated
    public JavaVersionTable getTable() {
        return this.table;
    }

    @Generated
    public Set<JavaVersion> getSeen() {
        return this.seen;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindJavaVersion(table=" + (Object)((Object)this.getTable()) + ", seen=" + this.getSeen() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindJavaVersion)) {
            return false;
        }
        FindJavaVersion other = (FindJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindJavaVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

