/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.SearchResult;

public final class FindDtoOverfetching
extends Recipe {
    @Option(displayName="DTO type", description="The fully qualified name of the DTO.", example="com.example.dto.*")
    private final String dtoType;
    private final String displayName = "Find methods that only use one DTO data element";
    private final String description = "Find methods that have 'opportunities' for improvement.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dtoFields = new MethodMatcher(this.dtoType + " get*()");
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                Set allUses = (Set)this.getCursor().getMessage("dtoDataUses", Collections.emptySet());
                if (allUses.size() == 1) {
                    return (J.MethodDeclaration)SearchResult.found((Tree)m, (String)String.join((CharSequence)", ", allUses));
                }
                return m;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Iterator methodDeclarations;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (method.getSelect() instanceof J.Identifier && dtoFields.matches((MethodCall)method) && (methodDeclarations = this.getCursor().getPathAsCursors(c -> c.getValue() instanceof J.MethodDeclaration)).hasNext()) {
                    Cursor methodCursor = (Cursor)methodDeclarations.next();
                    J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)methodCursor.getValue();
                    block0: for (Statement parameter : methodDeclaration.getParameters()) {
                        if (!(parameter instanceof J.VariableDeclarations)) continue;
                        J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)parameter;
                        for (J.VariableDeclarations.NamedVariable variable : variableDeclarations.getVariables()) {
                            if (!variable.getName().getSimpleName().equals(((J.Identifier)method.getSelect()).getSimpleName())) continue;
                            ((TreeSet)methodCursor.computeMessageIfAbsent("dtoDataUses", k -> new TreeSet())).add(StringUtils.uncapitalize((String)method.getSimpleName().replaceAll("^get", "")));
                            break block0;
                        }
                    }
                }
                return m;
            }
        };
    }

    @ConstructorProperties(value={"dtoType"})
    @Generated
    public FindDtoOverfetching(String dtoType) {
        this.dtoType = dtoType;
    }

    @Generated
    public String getDtoType() {
        return this.dtoType;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindDtoOverfetching(dtoType=" + this.getDtoType() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDtoOverfetching)) {
            return false;
        }
        FindDtoOverfetching other = (FindDtoOverfetching)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$dtoType = this.getDtoType();
        String other$dtoType = other.getDtoType();
        if (this$dtoType == null ? other$dtoType != null : !this$dtoType.equals(other$dtoType)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDtoOverfetching;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dtoType = this.getDtoType();
        result = result * 59 + ($dtoType == null ? 43 : $dtoType.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

