/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class AddJaxwsRuntime
extends Recipe {
    private static final String JAKARTA_JAXWS_API_GROUP = "jakarta.xml.ws";
    private static final String JAKARTA_JAXWS_API_ARTIFACT = "jakarta.xml.ws-api";
    private static final String SUN_JAXWS_RUNTIME_GROUP = "com.sun.xml.ws";
    private static final String SUN_JAXWS_RUNTIME_ARTIFACT = "jaxws-rt";
    private final String displayName = "Use the latest JAX-WS API and runtime for Jakarta EE 8";
    private final String description = "Update build files to use the latest JAX-WS runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater. The recipe will add a JAX-WS run-time, in Gradle `compileOnly`+`testImplementation` and Maven `provided` scope, to any project that has a transitive dependency on the JAX-WS API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(30L);
    private final Set<String> tags = new HashSet<String>(Arrays.asList("javax", "jakarta", "javaee", "jaxws", "java11"));

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AddJaxwsRuntimeGradle(), new AddJaxwsRuntimeMaven()});
    }

    @Generated
    public AddJaxwsRuntime() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddJaxwsRuntime(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddJaxwsRuntime)) {
            return false;
        }
        AddJaxwsRuntime other = (AddJaxwsRuntime)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        if (this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddJaxwsRuntime;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public static final class AddJaxwsRuntimeGradle
    extends Recipe {
        private final String displayName = "Use the latest JAX-WS API and runtime for Jakarta EE 8";
        private final String description = "Update Gradle build files to use the latest JAX-WS runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater.  The recipe will add a JAX-WS run-time, in `compileOnly`+`testImplementation` configurations, to any project that has a transitive dependency on the JAX-WS API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return Preconditions.check((TreeVisitor)new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

                public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                    G.CompilationUnit g = cu;
                    GradleProject gp = (GradleProject)g.getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new RuntimeException("Gradle build scripts must have a GradleProject marker"));
                    Set<GradleDependencyConfiguration> apiConfigurations = this.getTransitiveDependencyConfiguration(gp, AddJaxwsRuntime.JAKARTA_JAXWS_API_GROUP, AddJaxwsRuntime.JAKARTA_JAXWS_API_ARTIFACT);
                    if (!apiConfigurations.isEmpty()) {
                        Set<GradleDependencyConfiguration> runtimeConfigurations = this.getTransitiveDependencyConfiguration(gp, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT);
                        if (runtimeConfigurations.isEmpty()) {
                            if (gp.getConfiguration("compileOnly") != null) {
                                g = this.addJaxWsRuntimeDependency("compileOnly", g, ctx);
                            }
                            if (gp.getConfiguration("testImplementation") != null) {
                                g = this.addJaxWsRuntimeDependency("testImplementation", g, ctx);
                            }
                        } else {
                            for (GradleDependencyConfiguration apiConfiguration : apiConfigurations) {
                                List apiTransitives = gp.configurationsExtendingFrom(apiConfiguration, true);
                                for (GradleDependencyConfiguration runtimeConfiguration : runtimeConfigurations) {
                                    List runtimeTransitives = gp.configurationsExtendingFrom(runtimeConfiguration, true);
                                    if (!apiTransitives.stream().noneMatch(runtimeTransitives::contains) || !apiConfiguration.isCanBeDeclared()) continue;
                                    g = this.addJaxWsRuntimeDependency(apiConfiguration.getName(), g, ctx);
                                }
                            }
                        }
                    }
                    return g;
                }

                private Set<GradleDependencyConfiguration> getTransitiveDependencyConfiguration(GradleProject gp, String groupId, String artifactId) {
                    GradleDependencyConfiguration gdc;
                    HashSet<GradleDependencyConfiguration> configurations = new HashSet<GradleDependencyConfiguration>();
                    for (GradleDependencyConfiguration gdc2 : gp.getConfigurations()) {
                        if (gdc2.findRequestedDependency(groupId, artifactId) == null && gdc2.findResolvedDependency(groupId, artifactId) == null) continue;
                        configurations.add(gdc2);
                    }
                    HashSet tmpConfigurations = new HashSet(configurations);
                    for (GradleDependencyConfiguration tmpConfiguration : tmpConfigurations) {
                        gdc = gp.getConfiguration(tmpConfiguration.getName());
                        for (GradleDependencyConfiguration transitive : gp.configurationsExtendingFrom(gdc, true)) {
                            configurations.remove(transitive);
                        }
                    }
                    tmpConfigurations = new HashSet(configurations);
                    for (GradleDependencyConfiguration configuration : tmpConfigurations) {
                        gdc = gp.getConfiguration(configuration.getName());
                        for (GradleDependencyConfiguration extendsFrom : gdc.allExtendsFrom()) {
                            if (!configurations.contains(extendsFrom)) continue;
                            configurations.remove(configuration);
                        }
                    }
                    return configurations;
                }

                private G.CompilationUnit addJaxWsRuntimeDependency(String apiConfiguration, G.CompilationUnit g, ExecutionContext ctx) {
                    return (G.CompilationUnit)new AddDependencyVisitor(AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT, "2.3.x", null, apiConfiguration, null, null, null, null, null).visitNonNull((Tree)g, (Object)ctx);
                }
            });
        }

        @Generated
        public AddJaxwsRuntimeGradle() {
        }

        @Generated
        public String getDisplayName() {
            Objects.requireNonNull(this);
            return "Use the latest JAX-WS API and runtime for Jakarta EE 8";
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddJaxwsRuntime.AddJaxwsRuntimeGradle(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddJaxwsRuntimeGradle)) {
                return false;
            }
            AddJaxwsRuntimeGradle other = (AddJaxwsRuntimeGradle)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof AddJaxwsRuntimeGradle;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }
    }

    public static final class AddJaxwsRuntimeMaven
    extends Recipe {
        private final String displayName = "Use the latest JAX-WS API and runtime for Jakarta EE 8";
        private final String description = "Update maven build files to use the latest JAX-WS runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater.  The recipe will add a JAX-WS run-time, in `provided` scope, to any project that has a transitive dependency on the JAX-WS API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new MavenIsoVisitor<ExecutionContext>(){

                public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                    Scope runtimeScope;
                    Xml.Document d = super.visitDocument(document, (Object)ctx);
                    MavenResolutionResult mavenModel = this.getResolutionResult();
                    Scope apiScope = this.getTransitiveDependencyScope(mavenModel, AddJaxwsRuntime.JAKARTA_JAXWS_API_GROUP, AddJaxwsRuntime.JAKARTA_JAXWS_API_ARTIFACT);
                    if (!(apiScope == null || (runtimeScope = this.getTransitiveDependencyScope(mavenModel, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT)) != null && apiScope.isInClasspathOf(runtimeScope))) {
                        String resolvedScope = apiScope == Scope.Test ? "test" : "provided";
                        d = (Xml.Document)new org.openrewrite.maven.AddDependencyVisitor(AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT, "2.3.x", null, resolvedScope, null, null, null, null, null).visit((Tree)d, (Object)ctx);
                    }
                    return d;
                }
            };
        }

        private @Nullable Scope getTransitiveDependencyScope(MavenResolutionResult mavenModel, String groupId, String artifactId) {
            Scope maxScope = null;
            block0: for (Map.Entry entry : mavenModel.getDependencies().entrySet()) {
                for (ResolvedDependency dependency : (List)entry.getValue()) {
                    if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId())) continue;
                    if (Scope.Compile != (maxScope = Scope.maxPrecedence(maxScope, (Scope)((Scope)entry.getKey())))) continue block0;
                    return maxScope;
                }
            }
            return maxScope;
        }

        @Generated
        public AddJaxwsRuntimeMaven() {
        }

        @Generated
        public String getDisplayName() {
            Objects.requireNonNull(this);
            return "Use the latest JAX-WS API and runtime for Jakarta EE 8";
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddJaxwsRuntime.AddJaxwsRuntimeMaven(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddJaxwsRuntimeMaven)) {
                return false;
            }
            AddJaxwsRuntimeMaven other = (AddJaxwsRuntimeMaven)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof AddJaxwsRuntimeMaven;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }
    }
}

