/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class UpdateBeanManagerMethods
extends Recipe {
    final String displayName = "Update `fireEvent()` and `createInjectionTarget()` calls";
    final String description = "Updates `BeanManager.fireEvent()` or `BeanManager.createInjectionTarget()`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher fireEventMatcher = new MethodMatcher("*.enterprise.inject.spi.BeanManager fireEvent(..)", false);
            private final MethodMatcher createInjectionTargetMatcher = new MethodMatcher("*.enterprise.inject.spi.BeanManager createInjectionTarget(..)", false);

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                List arguments = mi.getArguments();
                if (this.fireEventMatcher.matches((MethodCall)method) && mi.getSelect() != null) {
                    if (arguments.size() <= 1) {
                        return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(jakarta.enterprise.inject.spi.BeanManager)}.getEvent().fire(#{any(jakarta.enterprise.inject.spi.BeforeBeanDiscovery)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.enterprise.cdi-api-3.0.0-M4"})).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getSelect(), arguments.get(0)});
                    }
                    Object[] args = new Expression[arguments.size() + 1];
                    args[0] = mi.getSelect();
                    for (int i = 1; i < arguments.size(); ++i) {
                        args[i] = arguments.get(i);
                    }
                    args[arguments.size()] = arguments.get(0);
                    String template = "#{any(jakarta.enterprise.inject.spi.BeanManager)}.getEvent().select(" + String.join((CharSequence)", ", Collections.nCopies(arguments.size() - 1, "#{any(java.lang.annotation.Annotation)}")) + ')' + ".fire(#{any(jakarta.enterprise.inject.spi.BeforeBeanDiscovery)})";
                    return (J.MethodInvocation)JavaTemplate.builder((String)template).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.enterprise.cdi-api-3.0.0-M4"})).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args);
                }
                if (this.createInjectionTargetMatcher.matches((MethodCall)method) && mi.getSelect() != null) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(jakarta.enterprise.inject.spi.BeanManager)}.getInjectionTargetFactory(#{any(jakarta.enterprise.inject.spi.AnnotatedType)}).createInjectionTarget(null)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.enterprise.cdi-api-3.0.0-M4"})).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi.getSelect(), arguments.get(0)});
                }
                return mi;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

