/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.io;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class ReplaceSystemOutWithIOPrint
extends Recipe {
    final String displayName = "Migrate `System.out.print` to Java 25 IO utility class";
    final String description = "Replace `System.out.print()`, `System.out.println()` with `IO.print()` and `IO.println()`. Migrates to the new IO utility class introduced in Java 25.";
    private static final MethodMatcher SYSTEM_OUT_PRINT = new MethodMatcher("java.io.PrintStream print(..)");
    private static final MethodMatcher SYSTEM_OUT_PRINTLN = new MethodMatcher("java.io.PrintStream println(..)");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(SYSTEM_OUT_PRINT), new UsesMethod(SYSTEM_OUT_PRINTLN)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (!this.isSystemOutMethod(m)) {
                    return m;
                }
                String methodName = m.getName().getSimpleName();
                return m.getArguments().isEmpty() ? (J.MethodInvocation)JavaTemplate.builder((String)"IO.#{}()").build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{methodName}) : (J.MethodInvocation)JavaTemplate.builder((String)"IO.#{}(#{any()})").build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{methodName, m.getArguments().get(0)});
            }

            private boolean isSystemOutMethod(J.MethodInvocation mi) {
                if (SYSTEM_OUT_PRINT.matches((MethodCall)mi) || SYSTEM_OUT_PRINTLN.matches((MethodCall)mi)) {
                    Expression expression = mi.getSelect();
                    if (expression instanceof J.FieldAccess) {
                        return this.isSystemOut(((J.FieldAccess)expression).getName());
                    }
                    if (expression instanceof J.Identifier) {
                        this.maybeRemoveImport("java.lang.System.out");
                        return this.isSystemOut((J.Identifier)expression);
                    }
                }
                return false;
            }

            private boolean isSystemOut(J.Identifier identifier) {
                return "out".equals(identifier.getSimpleName()) && identifier.getFieldType() != null && TypeUtils.isAssignableTo((String)"java.lang.System", (JavaType)identifier.getFieldType().getOwner());
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

