/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaOptionalToJavaUtil
extends Recipe {
    static final MethodMatcher METHOD_MATCHER = new MethodMatcher("com.google.common.base.Optional toJavaUtil()");
    final String displayName = "Remove `com.google.common.base.Optional#toJavaUtil()`";
    final String description = "Remove calls to `com.google.common.base.Optional#toJavaUtil()`.";
    final Set<String> tags = new HashSet<String>(Arrays.asList("RSPEC-S4738", "guava"));

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(METHOD_MATCHER), (TreeVisitor)new ReplaceToJavaUtilVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    private static class ReplaceToJavaUtilVisitor
    extends JavaVisitor<ExecutionContext> {
        private ReplaceToJavaUtilVisitor() {
        }

        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J c = super.visitCompilationUnit(cu, (Object)ctx);
            this.maybeRemoveImport("com.google.common.base.Optional");
            this.maybeAddImport("java.util.Optional");
            return c;
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi;
            J j = super.visitMethodInvocation(method, (Object)ctx);
            if (j instanceof J.MethodInvocation && METHOD_MATCHER.matches((MethodCall)(mi = (J.MethodInvocation)j))) {
                return mi.getSelect();
            }
            return j;
        }
    }
}

