/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class NoGuavaIterablesTransform
extends Recipe {
    private static final MethodMatcher ITERABLES_TRANSFORM = new MethodMatcher("com.google.common.collect.Iterables transform(java.lang.Iterable, com.google.common.base.Function)");
    final String displayName = "Prefer `Collection.stream().map(Function)` over `Iterables.transform`";
    final String description = "Prefer `Collection.stream().map(Function)` over `Iterables.transform(Collection, Function)`.";
    final Set<String> tags = Collections.singleton("guava");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ITERABLES_TRANSFORM), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (ITERABLES_TRANSFORM.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.base.Function");
                    this.maybeRemoveImport("com.google.common.collect.Iterables");
                    this.maybeAddImport("java.util.function.Function");
                    this.maybeAddImport("java.util.stream.Collectors");
                    if (TypeUtils.isAssignableTo((String)"java.util.Collection", (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                        return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(java.util.Collection)}.stream().map(#{any(java.util.function.Function)}).collect(Collectors.toList())").imports(new String[]{"java.util.stream.Collectors"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0), method.getArguments().get(1)});
                    }
                    return method;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

