/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class ReplaceComSunAWTUtilitiesMethods
extends Recipe {
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="com.sun.awt.AWTUtilities isTranslucencySupported(com.sun.awt.AWTUtilities.Translucency)", required=false)
    private final String getAWTIsWindowsTranslucencyPattern;
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="com.test.AWTUtilities isWindowOpaque(java.awt.Window)", required=false)
    private final String isWindowOpaquePattern;
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="com.test.AWTUtilities isTranslucencyCapable(java.awt.GraphicsConfiguration)", required=false)
    private final String isTranslucencyCapablePattern;
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="com.test.AWTUtilities setWindowOpacity(java.awt.Window, float)", required=false)
    private final String setWindowOpacityPattern;
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="com.test.AWTUtilities getWindowOpacity(java.awt.Window)", required=false)
    private final String getWindowOpacityPattern;
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="com.test.AWTUtilitiesTest getWindowShape(java.awt.Window)", required=false)
    private final String getWindowShapePattern;
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="com.test.AWTUtilities setComponentMixingCutoutShape(java.awt.Component,java.awt.Shape)", required=false)
    private final String setComponentMixingCutoutShapePattern;
    private final String displayName = "Replace `com.sun.awt.AWTUtilities` static method invocations";
    private final String description = "This recipe replaces several static calls  in `com.sun.awt.AWTUtilities` with the JavaSE 11 equivalent. The methods replaced are `AWTUtilities.isTranslucencySupported()`, `AWTUtilities.setWindowOpacity()`, `AWTUtilities.getWindowOpacity()`, `AWTUtilities.getWindowShape()`, `AWTUtilities.isWindowOpaque()`, `AWTUtilities.isTranslucencyCapable()` and `AWTUtilities.setComponentMixingCutoutShape()`.";

    @JsonCreator
    public ReplaceComSunAWTUtilitiesMethods() {
        this.getAWTIsWindowsTranslucencyPattern = "com.sun.awt.AWTUtilities isTranslucencySupported(com.sun.awt.AWTUtilities.Translucency)";
        this.getWindowOpacityPattern = "com.sun.awt.AWTUtilities getWindowOpacity(java.awt.Window)";
        this.getWindowShapePattern = "com.sun.awt.AWTUtilities getWindowShape(java.awt.Window)";
        this.isWindowOpaquePattern = "com.sun.awt.AWTUtilities isWindowOpaque(java.awt.Window)";
        this.isTranslucencyCapablePattern = "com.sun.awt.AWTUtilities isTranslucencyCapable(java.awt.GraphicsConfiguration)";
        this.setComponentMixingCutoutShapePattern = "com.sun.awt.AWTUtilities setComponentMixingCutoutShape(java.awt.Component,java.awt.Shape)";
        this.setWindowOpacityPattern = "com.sun.awt.AWTUtilities setWindowOpacity(java.awt.Window, float)";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher getAWTIsWindowsTranslucencyMethod = new MethodMatcher(this.getAWTIsWindowsTranslucencyPattern);
        final MethodMatcher getWindowOpacityPatternMethod = new MethodMatcher(this.getWindowOpacityPattern);
        final MethodMatcher getWindowShapePatternMethod = new MethodMatcher(this.getWindowShapePattern);
        final MethodMatcher isWindowOpaquePatternMethod = new MethodMatcher(this.isWindowOpaquePattern);
        final MethodMatcher isTranslucencyCapablePatternMethod = new MethodMatcher(this.isTranslucencyCapablePattern);
        final MethodMatcher setComponentMixingCutoutShapePatternMethod = new MethodMatcher(this.setComponentMixingCutoutShapePattern);
        final MethodMatcher setWindowOpacityPatternMethod = new MethodMatcher(this.setWindowOpacityPattern);
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                super.visitMethodInvocation(mi, (Object)ctx);
                if (getAWTIsWindowsTranslucencyMethod.matches((MethodCall)mi)) {
                    this.maybeRemoveImport(mi.getMethodType().getDeclaringType().getFullyQualifiedName());
                    this.maybeAddImport("java.awt.GraphicsDevice", false);
                    this.maybeAddImport("java.awt.GraphicsEnvironment", false);
                    this.maybeAddImport("java.awt.Window", false);
                    this.maybeAddImport("java.awt.GraphicsDevice.WindowTranslucency", false);
                    String templateString = "GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(WindowTranslucency." + ((J.FieldAccess)mi.getArguments().get(0)).getSimpleName();
                    return JavaTemplate.builder((String)templateString).imports(new String[]{"java.awt.GraphicsDevice", "java.awt.GraphicsEnvironment", "java.awt.Window", "java.awt.GraphicsDevice.WindowTranslucency"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[0]).withPrefix(mi.getPrefix());
                }
                if (isWindowOpaquePatternMethod.matches((MethodCall)mi)) {
                    this.maybeRemoveImport(mi.getMethodType().getDeclaringType().getFullyQualifiedName());
                    return JavaTemplate.builder((String)"#{any()}.isOpaque()").build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)}).withPrefix(mi.getPrefix());
                }
                if (isTranslucencyCapablePatternMethod.matches((MethodCall)mi)) {
                    this.maybeRemoveImport(mi.getMethodType().getDeclaringType().getFullyQualifiedName());
                    return JavaTemplate.builder((String)"#{any()}.isTranslucencyCapable()").build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)}).withPrefix(mi.getPrefix());
                }
                if (setWindowOpacityPatternMethod.matches((MethodCall)mi)) {
                    this.maybeRemoveImport(mi.getMethodType().getDeclaringType().getFullyQualifiedName());
                    return JavaTemplate.builder((String)"#{any()}.setOpacity(#{any()})").build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), mi.getArguments().get(1)}).withPrefix(mi.getPrefix());
                }
                if (getWindowOpacityPatternMethod.matches((MethodCall)mi)) {
                    this.maybeRemoveImport(mi.getMethodType().getDeclaringType().getFullyQualifiedName());
                    return JavaTemplate.builder((String)"#{any()}.getOpacity()").build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)}).withPrefix(mi.getPrefix());
                }
                if (getWindowShapePatternMethod.matches((MethodCall)mi)) {
                    this.maybeRemoveImport(mi.getMethodType().getDeclaringType().getFullyQualifiedName());
                    return JavaTemplate.builder((String)"#{any()}.getShape()").build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)}).withPrefix(mi.getPrefix());
                }
                if (setComponentMixingCutoutShapePatternMethod.matches((MethodCall)mi)) {
                    this.maybeRemoveImport(mi.getMethodType().getDeclaringType().getFullyQualifiedName());
                    return JavaTemplate.builder((String)"#{any()}.setMixingCutoutShape(#{any()})").build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), mi.getArguments().get(1)}).withPrefix(mi.getPrefix());
                }
                return mi;
            }
        };
    }

    @Generated
    public String getGetAWTIsWindowsTranslucencyPattern() {
        return this.getAWTIsWindowsTranslucencyPattern;
    }

    @Generated
    public String getIsWindowOpaquePattern() {
        return this.isWindowOpaquePattern;
    }

    @Generated
    public String getIsTranslucencyCapablePattern() {
        return this.isTranslucencyCapablePattern;
    }

    @Generated
    public String getSetWindowOpacityPattern() {
        return this.setWindowOpacityPattern;
    }

    @Generated
    public String getGetWindowOpacityPattern() {
        return this.getWindowOpacityPattern;
    }

    @Generated
    public String getGetWindowShapePattern() {
        return this.getWindowShapePattern;
    }

    @Generated
    public String getSetComponentMixingCutoutShapePattern() {
        return this.setComponentMixingCutoutShapePattern;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceComSunAWTUtilitiesMethods(getAWTIsWindowsTranslucencyPattern=" + this.getGetAWTIsWindowsTranslucencyPattern() + ", isWindowOpaquePattern=" + this.getIsWindowOpaquePattern() + ", isTranslucencyCapablePattern=" + this.getIsTranslucencyCapablePattern() + ", setWindowOpacityPattern=" + this.getSetWindowOpacityPattern() + ", getWindowOpacityPattern=" + this.getGetWindowOpacityPattern() + ", getWindowShapePattern=" + this.getGetWindowShapePattern() + ", setComponentMixingCutoutShapePattern=" + this.getSetComponentMixingCutoutShapePattern() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @ConstructorProperties(value={"getAWTIsWindowsTranslucencyPattern", "isWindowOpaquePattern", "isTranslucencyCapablePattern", "setWindowOpacityPattern", "getWindowOpacityPattern", "getWindowShapePattern", "setComponentMixingCutoutShapePattern"})
    @Generated
    public ReplaceComSunAWTUtilitiesMethods(String getAWTIsWindowsTranslucencyPattern, String isWindowOpaquePattern, String isTranslucencyCapablePattern, String setWindowOpacityPattern, String getWindowOpacityPattern, String getWindowShapePattern, String setComponentMixingCutoutShapePattern) {
        this.getAWTIsWindowsTranslucencyPattern = getAWTIsWindowsTranslucencyPattern;
        this.isWindowOpaquePattern = isWindowOpaquePattern;
        this.isTranslucencyCapablePattern = isTranslucencyCapablePattern;
        this.setWindowOpacityPattern = setWindowOpacityPattern;
        this.getWindowOpacityPattern = getWindowOpacityPattern;
        this.getWindowShapePattern = getWindowShapePattern;
        this.setComponentMixingCutoutShapePattern = setComponentMixingCutoutShapePattern;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceComSunAWTUtilitiesMethods)) {
            return false;
        }
        ReplaceComSunAWTUtilitiesMethods other = (ReplaceComSunAWTUtilitiesMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$getAWTIsWindowsTranslucencyPattern = this.getGetAWTIsWindowsTranslucencyPattern();
        String other$getAWTIsWindowsTranslucencyPattern = other.getGetAWTIsWindowsTranslucencyPattern();
        if (this$getAWTIsWindowsTranslucencyPattern == null ? other$getAWTIsWindowsTranslucencyPattern != null : !this$getAWTIsWindowsTranslucencyPattern.equals(other$getAWTIsWindowsTranslucencyPattern)) {
            return false;
        }
        String this$isWindowOpaquePattern = this.getIsWindowOpaquePattern();
        String other$isWindowOpaquePattern = other.getIsWindowOpaquePattern();
        if (this$isWindowOpaquePattern == null ? other$isWindowOpaquePattern != null : !this$isWindowOpaquePattern.equals(other$isWindowOpaquePattern)) {
            return false;
        }
        String this$isTranslucencyCapablePattern = this.getIsTranslucencyCapablePattern();
        String other$isTranslucencyCapablePattern = other.getIsTranslucencyCapablePattern();
        if (this$isTranslucencyCapablePattern == null ? other$isTranslucencyCapablePattern != null : !this$isTranslucencyCapablePattern.equals(other$isTranslucencyCapablePattern)) {
            return false;
        }
        String this$setWindowOpacityPattern = this.getSetWindowOpacityPattern();
        String other$setWindowOpacityPattern = other.getSetWindowOpacityPattern();
        if (this$setWindowOpacityPattern == null ? other$setWindowOpacityPattern != null : !this$setWindowOpacityPattern.equals(other$setWindowOpacityPattern)) {
            return false;
        }
        String this$getWindowOpacityPattern = this.getGetWindowOpacityPattern();
        String other$getWindowOpacityPattern = other.getGetWindowOpacityPattern();
        if (this$getWindowOpacityPattern == null ? other$getWindowOpacityPattern != null : !this$getWindowOpacityPattern.equals(other$getWindowOpacityPattern)) {
            return false;
        }
        String this$getWindowShapePattern = this.getGetWindowShapePattern();
        String other$getWindowShapePattern = other.getGetWindowShapePattern();
        if (this$getWindowShapePattern == null ? other$getWindowShapePattern != null : !this$getWindowShapePattern.equals(other$getWindowShapePattern)) {
            return false;
        }
        String this$setComponentMixingCutoutShapePattern = this.getSetComponentMixingCutoutShapePattern();
        String other$setComponentMixingCutoutShapePattern = other.getSetComponentMixingCutoutShapePattern();
        if (this$setComponentMixingCutoutShapePattern == null ? other$setComponentMixingCutoutShapePattern != null : !this$setComponentMixingCutoutShapePattern.equals(other$setComponentMixingCutoutShapePattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceComSunAWTUtilitiesMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $getAWTIsWindowsTranslucencyPattern = this.getGetAWTIsWindowsTranslucencyPattern();
        result = result * 59 + ($getAWTIsWindowsTranslucencyPattern == null ? 43 : $getAWTIsWindowsTranslucencyPattern.hashCode());
        String $isWindowOpaquePattern = this.getIsWindowOpaquePattern();
        result = result * 59 + ($isWindowOpaquePattern == null ? 43 : $isWindowOpaquePattern.hashCode());
        String $isTranslucencyCapablePattern = this.getIsTranslucencyCapablePattern();
        result = result * 59 + ($isTranslucencyCapablePattern == null ? 43 : $isTranslucencyCapablePattern.hashCode());
        String $setWindowOpacityPattern = this.getSetWindowOpacityPattern();
        result = result * 59 + ($setWindowOpacityPattern == null ? 43 : $setWindowOpacityPattern.hashCode());
        String $getWindowOpacityPattern = this.getGetWindowOpacityPattern();
        result = result * 59 + ($getWindowOpacityPattern == null ? 43 : $getWindowOpacityPattern.hashCode());
        String $getWindowShapePattern = this.getGetWindowShapePattern();
        result = result * 59 + ($getWindowShapePattern == null ? 43 : $getWindowShapePattern.hashCode());
        String $setComponentMixingCutoutShapePattern = this.getSetComponentMixingCutoutShapePattern();
        result = result * 59 + ($setComponentMixingCutoutShapePattern == null ? 43 : $setComponentMixingCutoutShapePattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

