/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.staticanalysis.ModifierOrder;

public final class MXBeanRule
extends Recipe {
    private final String displayName = "MBean and MXBean interfaces must be public";
    private final String description = "Sets visibility of MBean and MXBean interfaces to public.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new JavaVisitor<ExecutionContext>(){

            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (!classDecl.hasModifier(J.Modifier.Type.Public) && classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
                    return (J)SearchResult.found((Tree)classDecl, (String)"Not yet public interface");
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
        }, Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.management.MXBean", Boolean.valueOf(true)), new JavaVisitor<ExecutionContext>(){

            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                String className = classDecl.getName().getSimpleName();
                if (className.endsWith("MXBean") || className.endsWith("MBean")) {
                    return (J)SearchResult.found((Tree)classDecl, (String)"Matching class name");
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
        }})}), (TreeVisitor)new ClassImplementationVisitor());
    }

    @Generated
    public MXBeanRule() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MXBeanRule(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MXBeanRule)) {
            return false;
        }
        MXBeanRule other = (MXBeanRule)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MXBeanRule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class ClassImplementationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher MX_BEAN = new AnnotationMatcher("@javax.management.MXBean");
        private static final AnnotationMatcher MX_BEAN_VALUE_TRUE = new AnnotationMatcher("@javax.management.MXBean(value=true)");

        private ClassImplementationVisitor() {
        }

        private boolean shouldUpdate(J.ClassDeclaration classDecl) {
            List leadingAnnotations = classDecl.getLeadingAnnotations();
            Optional<J.Annotation> firstAnnotation = leadingAnnotations.stream().filter(arg_0 -> ((AnnotationMatcher)MX_BEAN).matches(arg_0)).findFirst();
            if (firstAnnotation.isPresent()) {
                List arguments = firstAnnotation.get().getArguments();
                return arguments == null || arguments.isEmpty() || MX_BEAN_VALUE_TRUE.matches(firstAnnotation.get());
            }
            String className = classDecl.getName().getSimpleName();
            return className.endsWith("MXBean") || className.endsWith("MBean");
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDeclaration, (Object)ctx);
            if (!this.shouldUpdate(cd)) {
                return cd;
            }
            ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>(cd.getModifiers());
            modifiers.removeIf(modifier -> modifier.getType() == J.Modifier.Type.Private || modifier.getType() == J.Modifier.Type.Protected || modifier.getType() == J.Modifier.Type.Abstract);
            modifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, J.Modifier.Type.Public, Collections.emptyList()));
            return (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)cd.withModifiers(ModifierOrder.sortModifiers(modifiers)), ctx);
        }
    }
}

