/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import lombok.Getter;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lombok.FieldAnnotator;
import org.openrewrite.java.migrate.lombok.LombokUtils;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class UseLombokGetter
extends Recipe {
    public String getDisplayName() {
        return "Convert getter methods to annotations";
    }

    public String getDescription() {
        return "Convert trivial getter methods to `@Getter` annotations on their respective fields.";
    }

    public Set<String> getTags() {
        return Collections.singleton("lombok");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (LombokUtils.isGetter(this.getCursor())) {
                    Expression returnExpression = ((J.Return)method.getBody().getStatements().get(0)).getExpression();
                    List onMethodAnnotations = ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor());
                    if (returnExpression instanceof J.Identifier && ((J.Identifier)returnExpression).getFieldType() != null) {
                        this.doAfterVisit((TreeVisitor)new FieldAnnotator(Getter.class, (JavaType)((J.Identifier)returnExpression).getFieldType(), LombokUtils.getAccessLevel(method), onMethodAnnotations));
                        return null;
                    }
                    if (returnExpression instanceof J.FieldAccess && ((J.FieldAccess)returnExpression).getName().getFieldType() != null) {
                        this.doAfterVisit((TreeVisitor)new FieldAnnotator(Getter.class, (JavaType)((J.FieldAccess)returnExpression).getName().getFieldType(), LombokUtils.getAccessLevel(method), onMethodAnnotations));
                        return null;
                    }
                }
                return method;
            }
        };
    }

    @Generated
    public UseLombokGetter() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseLombokGetter()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseLombokGetter)) {
            return false;
        }
        UseLombokGetter other = (UseLombokGetter)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UseLombokGetter;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

