/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.AccessLevel;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

final class FieldAnnotator
extends JavaIsoVisitor<ExecutionContext> {
    private static final AnnotationMatcher OVERRIDE_MATCHER = new AnnotationMatcher("java.lang.Override");
    private final Class<?> annotation;
    private final JavaType field;
    private final AccessLevel accessLevel;
    private final List<J.Annotation> onMethodAnnotations;

    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
        for (J.VariableDeclarations.NamedVariable variable : multiVariable.getVariables()) {
            if (variable.getName().getFieldType() != this.field) continue;
            String annotationName = this.annotation.getSimpleName();
            if (multiVariable.getLeadingAnnotations().stream().noneMatch(ann -> annotationName.equals(ann.getSimpleName()))) {
                String suffix;
                this.maybeAddImport(this.annotation.getName());
                this.maybeAddImport("lombok.AccessLevel");
                String valueArg = this.accessLevel == AccessLevel.PUBLIC ? "" : String.format("AccessLevel.%s", this.accessLevel.name());
                this.onMethodAnnotations.removeIf(arg_0 -> ((AnnotationMatcher)OVERRIDE_MATCHER).matches(arg_0));
                if (this.onMethodAnnotations.isEmpty()) {
                    suffix = valueArg.isEmpty() ? "" : String.format("(%s)", valueArg);
                } else {
                    String onMethodArg = String.format("onMethod_ = {%s}", this.onMethodAnnotations.stream().map(J.Annotation::toString).collect(Collectors.joining(",")));
                    suffix = valueArg.isEmpty() ? String.format("(%s)", onMethodArg) : String.format("(value = %s, %s)", valueArg, onMethodArg);
                }
                return (J.VariableDeclarations)JavaTemplate.builder((String)("@" + this.annotation.getSimpleName() + suffix)).imports(new String[]{this.annotation.getName(), "lombok.AccessLevel"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"lombok"})).build().apply(this.getCursor(), multiVariable.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
            return multiVariable;
        }
        return multiVariable;
    }

    @ConstructorProperties(value={"annotation", "field", "accessLevel", "onMethodAnnotations"})
    @Generated
    public FieldAnnotator(Class<?> annotation, JavaType field, AccessLevel accessLevel, List<J.Annotation> onMethodAnnotations) {
        this.annotation = annotation;
        this.field = field;
        this.accessLevel = accessLevel;
        this.onMethodAnnotations = onMethodAnnotations;
    }

    @Generated
    public Class<?> getAnnotation() {
        return this.annotation;
    }

    @Generated
    public JavaType getField() {
        return this.field;
    }

    @Generated
    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    @Generated
    public List<J.Annotation> getOnMethodAnnotations() {
        return this.onMethodAnnotations;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FieldAnnotator(annotation=" + this.getAnnotation() + ", field=" + this.getField() + ", accessLevel=" + this.getAccessLevel() + ", onMethodAnnotations=" + this.getOnMethodAnnotations() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldAnnotator)) {
            return false;
        }
        FieldAnnotator other = (FieldAnnotator)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Class<?> this$annotation = this.getAnnotation();
        Class<?> other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
            return false;
        }
        JavaType this$field = this.getField();
        JavaType other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        AccessLevel this$accessLevel = this.getAccessLevel();
        AccessLevel other$accessLevel = other.getAccessLevel();
        if (this$accessLevel == null ? other$accessLevel != null : !this$accessLevel.equals(other$accessLevel)) {
            return false;
        }
        List<J.Annotation> this$onMethodAnnotations = this.getOnMethodAnnotations();
        List<J.Annotation> other$onMethodAnnotations = other.getOnMethodAnnotations();
        return !(this$onMethodAnnotations == null ? other$onMethodAnnotations != null : !((Object)this$onMethodAnnotations).equals(other$onMethodAnnotations));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FieldAnnotator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
        JavaType $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        AccessLevel $accessLevel = this.getAccessLevel();
        result = result * 59 + ($accessLevel == null ? 43 : $accessLevel.hashCode());
        List<J.Annotation> $onMethodAnnotations = this.getOnMethodAnnotations();
        result = result * 59 + ($onMethodAnnotations == null ? 43 : ((Object)$onMethodAnnotations).hashCode());
        return result;
    }
}

