/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.ArrayList;
import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public class ListFirstAndLast
extends Recipe {
    private static final MethodMatcher ADD_MATCHER = new MethodMatcher("java.util.List add(int, ..)", true);
    private static final MethodMatcher GET_MATCHER = new MethodMatcher("java.util.List get(int)", true);
    private static final MethodMatcher REMOVE_MATCHER = new MethodMatcher("java.util.List remove(int)", true);
    private static final MethodMatcher SIZE_MATCHER = new MethodMatcher("java.util.List size()", true);

    public String getDisplayName() {
        return "Replace `List` `get`, `add`, and `remove` with `SequencedCollection` `*First` and `*Last` methods";
    }

    public String getDescription() {
        return "Replace `list.get(0)` with `list.getFirst()`, `list.get(list.size() - 1)` with `list.getLast()`, and similar for `add(int, E)` and `remove(int)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(21), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(ADD_MATCHER), new UsesMethod(GET_MATCHER), new UsesMethod(REMOVE_MATCHER)})}), (TreeVisitor)new FirstLastVisitor());
    }

    private static class FirstLastVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private FirstLastVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            JavaType.Method newMethodType;
            String firstOrLast;
            String operation;
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            Expression select = mi.getSelect();
            if (!(select instanceof J.Identifier)) {
                return mi;
            }
            J.Identifier sequencedCollection = (J.Identifier)select;
            if (ADD_MATCHER.matches((MethodCall)mi)) {
                operation = "add";
            } else if (GET_MATCHER.matches((MethodCall)mi)) {
                operation = "get";
            } else if (REMOVE_MATCHER.matches((MethodCall)mi)) {
                operation = "remove";
            } else {
                return mi;
            }
            Expression expression = (Expression)mi.getArguments().get(0);
            if (J.Literal.isLiteralValue((Expression)expression, (Object)0)) {
                firstOrLast = "First";
            } else if (!"add".equals(operation) && FirstLastVisitor.lastElementOfSequencedCollection(sequencedCollection, expression)) {
                firstOrLast = "Last";
            } else {
                return mi;
            }
            ArrayList<Expression> arguments = new ArrayList<Expression>();
            JavaType.Method originalMethodType = mi.getMethodType();
            if ("add".equals(operation)) {
                arguments.add((Expression)((Expression)mi.getArguments().get(1)).withPrefix(Space.EMPTY));
                newMethodType = originalMethodType.withName(operation + firstOrLast).withParameterNames(Collections.singletonList((String)originalMethodType.getParameterNames().get(1))).withParameterTypes(Collections.singletonList((JavaType)originalMethodType.getParameterTypes().get(1)));
            } else {
                newMethodType = originalMethodType.withName(operation + firstOrLast).withParameterNames(null).withParameterTypes(null);
            }
            return mi.withName(mi.getName().withSimpleName(operation + firstOrLast).withType((JavaType)newMethodType)).withArguments(arguments).withMethodType(newMethodType);
        }

        private static boolean lastElementOfSequencedCollection(J.Identifier sequencedCollection, Expression expression) {
            Expression sizeSelect;
            J.Binary binary;
            if (expression instanceof J.Binary && (binary = (J.Binary)expression).getOperator() == J.Binary.Type.Subtraction && J.Literal.isLiteralValue((Expression)binary.getRight(), (Object)1) && SIZE_MATCHER.matches(binary.getLeft()) && (sizeSelect = ((J.MethodInvocation)binary.getLeft()).getSelect()) instanceof J.Identifier) {
                return sequencedCollection.getSimpleName().equals(((J.Identifier)sizeSelect).getSimpleName());
            }
            return false;
        }
    }
}

