/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class ChangeMethodInvocationReturnType
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method declarations/invocations.", example="org.mockito.Matchers anyVararg()")
    private final String methodPattern;
    @Option(displayName="New method invocation return type", description="The return return type of method invocation.", example="long")
    private final String newReturnType;

    public String getDisplayName() {
        return "Change method invocation return type";
    }

    public String getDescription() {
        return "Changes the return type of a method invocation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher methodMatcher;
            private boolean methodUpdated;
            {
                this.methodMatcher = new MethodMatcher(ChangeMethodInvocationReturnType.this.methodPattern, false);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                JavaType.Method type = m.getMethodType();
                if (this.methodMatcher.matches((MethodCall)method) && type != null && !ChangeMethodInvocationReturnType.this.newReturnType.equals(type.getReturnType().toString())) {
                    if ((m = m.withMethodType(type = type.withReturnType(JavaType.buildType((String)ChangeMethodInvocationReturnType.this.newReturnType)))).getName().getType() != null) {
                        m = m.withName(m.getName().withType((JavaType)type));
                    }
                    this.methodUpdated = true;
                }
                return m;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                this.methodUpdated = false;
                JavaType.FullyQualified originalType = multiVariable.getTypeAsFullyQualified();
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (this.methodUpdated) {
                    JavaType newType = JavaType.buildType((String)ChangeMethodInvocationReturnType.this.newReturnType);
                    JavaType.FullyQualified newFieldType = TypeUtils.asFullyQualified((JavaType)newType);
                    this.maybeAddImport(newFieldType);
                    this.maybeRemoveImport(originalType);
                    mv = mv.withTypeExpression((TypeTree)(mv.getTypeExpression() == null ? null : new J.Identifier(mv.getTypeExpression().getId(), mv.getTypeExpression().getPrefix(), Markers.EMPTY, Collections.emptyList(), ChangeMethodInvocationReturnType.this.newReturnType, newType, null)));
                    mv = mv.withVariables(ListUtils.map((List)mv.getVariables(), var -> {
                        JavaType.FullyQualified varType = TypeUtils.asFullyQualified((JavaType)var.getType());
                        if (varType != null && !varType.equals(newType)) {
                            return var.withType(newType).withName(var.getName().withType(newType));
                        }
                        return var;
                    }));
                }
                return mv;
            }
        };
    }

    @ConstructorProperties(value={"methodPattern", "newReturnType"})
    public ChangeMethodInvocationReturnType(String methodPattern, String newReturnType) {
        this.methodPattern = methodPattern;
        this.newReturnType = newReturnType;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getNewReturnType() {
        return this.newReturnType;
    }

    @NonNull
    public String toString() {
        return "ChangeMethodInvocationReturnType(methodPattern=" + this.getMethodPattern() + ", newReturnType=" + this.getNewReturnType() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodInvocationReturnType)) {
            return false;
        }
        ChangeMethodInvocationReturnType other = (ChangeMethodInvocationReturnType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$newReturnType = this.getNewReturnType();
        String other$newReturnType = other.getNewReturnType();
        return !(this$newReturnType == null ? other$newReturnType != null : !this$newReturnType.equals(other$newReturnType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeMethodInvocationReturnType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $newReturnType = this.getNewReturnType();
        result = result * 59 + ($newReturnType == null ? 43 : $newReturnType.hashCode());
        return result;
    }
}

