/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public class OptionalStreamRecipe
extends Recipe {
    private static final MethodMatcher mapMatcher = new MethodMatcher("java.util.stream.Stream map(java.util.function.Function)");
    private static final MethodMatcher filterMatcher = new MethodMatcher("java.util.stream.Stream filter(java.util.function.Predicate)");
    private static final MethodMatcher optionalGetMatcher = new MethodMatcher("java.util.Optional get()");
    private static final MethodMatcher optionalIsPresentMatcher = new MethodMatcher("java.util.Optional isPresent()");

    public String getDisplayName() {
        return "`Stream<Optional>` idiom recipe";
    }

    public String getDescription() {
        return "Migrate Java 8 `Optional<Stream>.filter(Optional::isPresent).map(Optional::get)` to Java 11 `.flatMap(Optional::stream)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(optionalIsPresentMatcher), (TreeVisitor)new OptionalStreamVisitor());
    }

    private static class OptionalStreamVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private OptionalStreamVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation invocation, ExecutionContext ctx) {
            J.MethodInvocation mapInvocation = super.visitMethodInvocation(invocation, (Object)ctx);
            if (!mapMatcher.matches((MethodCall)mapInvocation) || !optionalGetMatcher.matches((Expression)mapInvocation.getArguments().get(0))) {
                return mapInvocation;
            }
            Expression mapSelectExpr = mapInvocation.getSelect();
            if (!filterMatcher.matches(mapSelectExpr)) {
                return mapInvocation;
            }
            J.MethodInvocation filterInvocation = (J.MethodInvocation)mapSelectExpr;
            if (!optionalIsPresentMatcher.matches((Expression)filterInvocation.getArguments().get(0))) {
                return mapInvocation;
            }
            JRightPadded filterSelect = filterInvocation.getPadding().getSelect();
            JRightPadded mapSelect = mapInvocation.getPadding().getSelect();
            JavaType.Method mapInvocationType = mapInvocation.getMethodType();
            Space flatMapComments = OptionalStreamVisitor.getFlatMapComments((JRightPadded<Expression>)mapSelect, (JRightPadded<Expression>)filterSelect);
            JavaTemplate template = JavaTemplate.builder((String)"#{any(java.util.stream.Stream)}.flatMap(Optional::stream)").imports(new String[]{"java.util.Optional"}).build();
            J.MethodInvocation flatMapInvocation = (J.MethodInvocation)template.apply(this.updateCursor((Tree)mapInvocation), mapInvocation.getCoordinates().replace(), new Object[]{filterInvocation.getSelect()});
            return flatMapInvocation.getPadding().withSelect(filterSelect.withAfter(flatMapComments)).withMethodType(mapInvocationType.withName("flatMap")).withPrefix(mapInvocation.getPrefix());
        }

        private static Space getFlatMapComments(JRightPadded<Expression> mapSelect, JRightPadded<Expression> filterSelect) {
            ArrayList comments = new ArrayList();
            comments.addAll(filterSelect.getAfter().getComments());
            comments.addAll(mapSelect.getAfter().getComments());
            return filterSelect.getAfter().withComments(comments);
        }
    }
}

