/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class PreferJavaUtilOptionalOrElseNull
extends Recipe {
    public String getDisplayName() {
        return "Prefer `java.util.Optional#orElse(null)` over `com.google.common.base.Optional#orNull()`";
    }

    public String getDescription() {
        return "Replaces `com.google.common.base.Optional#orNull()` with `java.util.Optional#orElse(null)`.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-4738", "guava"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.base.Optional orNull()"), (TreeVisitor)new PreferJavaUtilOptionalOrElseNullVisitor());
    }

    private static class PreferJavaUtilOptionalOrElseNullVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher OPTIONAL_OR_NULL_MATCHER = new MethodMatcher("com.google.common.base.Optional orNull()");

        private PreferJavaUtilOptionalOrElseNullVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
            this.maybeAddImport("java.util.Optional");
            this.maybeRemoveImport("com.google.common.base.Optional");
            return c;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (OPTIONAL_OR_NULL_MATCHER.matches((MethodCall)mi)) {
                mi = mi.withName(mi.getName().withSimpleName("orElse"));
                mi = (J.MethodInvocation)JavaTemplate.builder((String)"null").build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replaceArguments(), new Object[0]);
            }
            return mi;
        }
    }
}

