/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Refaster style Guava to Java migration recipes", description="Recipes that migrate from Guava to Java, using Refaster style templates for cases beyond what declarative recipes can cover.")
public class NoGuavaRefaster {

    @RecipeDescriptor(name="`String.valueof(String)` to `String`", description="Migrate from `String.valueof(String)` to `String`, mainly as a cleanup after other recipes.")
    public static class StringValueOfString {
        String before(String string) {
            return String.valueOf(string);
        }

        String after(String string) {
            return string;
        }
    }

    @RecipeDescriptor(name="`Preconditions.checkNotNull` to `Objects.requireNonNull`", description="Migrate from Guava `Preconditions.checkNotNull` to Java 8 `java.util.Objects.requireNonNull`.")
    public static class PreconditionsCheckNotNullToObjectsRequireNonNull {
        Object before(Object object, Object message) {
            return Preconditions.checkNotNull((Object)object, (Object)message);
        }

        Object after(Object object, Object message) {
            return Objects.requireNonNull(object, String.valueOf(message));
        }
    }
}

