/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddPlugin;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="0.2.0")
public class AddJDeprScanPlugin
extends Recipe {
    @Option(displayName="release", description="Specifies the Java SE release that provides the set of deprecated APIs for scanning.", required=false, example="11")
    private final String release;

    public String getDisplayName() {
        return "Add `JDeprScan` Maven Plug-in";
    }

    public String getDescription() {
        return "Add the `JDeprScan` Maven plugin to scan class files for uses of deprecated APIs.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Nullable
            public Xml preVisit(Xml tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                return (Xml)new AddJDeprScanPluginVisitor().visit((Tree)tree, ctx);
            }
        };
    }

    @ConstructorProperties(value={"release"})
    public AddJDeprScanPlugin(String release) {
        this.release = release;
    }

    public String getRelease() {
        return this.release;
    }

    private class AddJDeprScanPluginVisitor
    extends MavenVisitor<ExecutionContext> {
        private AddJDeprScanPluginVisitor() {
        }

        public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
            this.doAfterVisit(new AddPlugin("org.apache.maven.plugins", "maven-jdeprscan-plugin", "3.0.0-alpha-1", String.format("<configuration>%n   <release>%s</release>%n</configuration>", StringUtils.isNullOrEmpty((String)AddJDeprScanPlugin.this.getRelease()) ? "11" : AddJDeprScanPlugin.this.getRelease()), null, null, null).getVisitor());
            return document;
        }
    }
}

