/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Comparator;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddOrUpdateAnnotationAttribute;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public final class AddColumnAnnotation
extends Recipe {
    public String getDisplayName() {
        return "`@ElementCollection` annotations must be accompanied by a defined `@Column` annotation";
    }

    public String getDescription() {
        return "When an attribute is annotated with `@ElementCollection`, a separate table is created for the attribute that includes the attribute \nID and value. In OpenJPA, the column for the annotated attribute is named element, whereas EclipseLink names the column based on \nthe name of the attribute. To remain compatible with tables that were created with OpenJPA, add a `@Column` annotation with the name \nattribute set to element.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("javax.persistence.ElementCollection", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            boolean visitedTopLevelClass = false;

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (this.visitedTopLevelClass) {
                    return super.visitClassDeclaration(classDecl, (Object)ctx);
                }
                this.visitedTopLevelClass = true;
                if (!FindAnnotations.find((J)classDecl, (String)"@javax.persistence.Entity").isEmpty()) {
                    return super.visitClassDeclaration(classDecl, (Object)ctx);
                }
                return classDecl;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (FindAnnotations.find((J)multiVariable, (String)"@javax.persistence.ElementCollection").isEmpty() || !FindAnnotations.find((J)multiVariable, (String)"@javax.persistence.Transient").isEmpty()) {
                    return multiVariable;
                }
                if (FindAnnotations.find((J)multiVariable, (String)"@javax.persistence.Column").isEmpty()) {
                    this.maybeAddImport("javax.persistence.Column");
                    return (J.VariableDeclarations)JavaTemplate.builder((String)"@Column(name = \"element\")").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"javax.persistence-api-2.2"})).imports(new String[]{"javax.persistence.Column"}).build().apply(this.getCursor(), multiVariable.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                }
                J.VariableDeclarations updatedVariable = (J.VariableDeclarations)new AddOrUpdateAnnotationAttribute("javax.persistence.Column", "name", "element", Boolean.valueOf(true)).getVisitor().visit((Tree)multiVariable, (Object)ctx, this.getCursor());
                return super.visitVariableDeclarations(updatedVariable, (Object)ctx);
            }
        });
    }

    @Generated
    public AddColumnAnnotation() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddColumnAnnotation()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddColumnAnnotation)) {
            return false;
        }
        AddColumnAnnotation other = (AddColumnAnnotation)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddColumnAnnotation;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

