/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public class AddJaxwsRuntime
extends Recipe {
    private static final String JAKARTA_JAXWS_API_GROUP = "jakarta.xml.ws";
    private static final String JAKARTA_JAXWS_API_ARTIFACT = "jakarta.xml.ws-api";
    private static final String SUN_JAXWS_RUNTIME_GROUP = "com.sun.xml.ws";
    private static final String SUN_JAXWS_RUNTIME_ARTIFACT = "jaxws-rt";
    private final AddJaxwsRuntimeGradle addJaxwsRuntimeGradle = new AddJaxwsRuntimeGradle();
    private final AddJaxwsRuntimeMaven addJaxwsRuntimeMaven = new AddJaxwsRuntimeMaven();

    public String getDisplayName() {
        return "Use the latest JAX-WS API and runtime for Jakarta EE 8";
    }

    public String getDescription() {
        return "Update build files to use the latest JAX-WS runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater. The recipe will add a JAX-WS run-time, in Gradle `compileOnly`+`testImplementation` and Maven `provided` scope, to any project that has a transitive dependency on the JAX-WS API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(30L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("javax", "jakarta", "javaee", "jaxws", "java11"));
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{this.addJaxwsRuntimeGradle, this.addJaxwsRuntimeMaven});
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddJaxwsRuntime)) {
            return false;
        }
        AddJaxwsRuntime other = (AddJaxwsRuntime)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AddJaxwsRuntimeGradle this$addJaxwsRuntimeGradle = this.addJaxwsRuntimeGradle;
        AddJaxwsRuntimeGradle other$addJaxwsRuntimeGradle = other.addJaxwsRuntimeGradle;
        if (this$addJaxwsRuntimeGradle == null ? other$addJaxwsRuntimeGradle != null : !((Object)((Object)this$addJaxwsRuntimeGradle)).equals((Object)other$addJaxwsRuntimeGradle)) {
            return false;
        }
        AddJaxwsRuntimeMaven this$addJaxwsRuntimeMaven = this.addJaxwsRuntimeMaven;
        AddJaxwsRuntimeMaven other$addJaxwsRuntimeMaven = other.addJaxwsRuntimeMaven;
        return !(this$addJaxwsRuntimeMaven == null ? other$addJaxwsRuntimeMaven != null : !((Object)((Object)this$addJaxwsRuntimeMaven)).equals((Object)other$addJaxwsRuntimeMaven));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddJaxwsRuntime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AddJaxwsRuntimeGradle $addJaxwsRuntimeGradle = this.addJaxwsRuntimeGradle;
        result = result * 59 + ($addJaxwsRuntimeGradle == null ? 43 : ((Object)((Object)$addJaxwsRuntimeGradle)).hashCode());
        AddJaxwsRuntimeMaven $addJaxwsRuntimeMaven = this.addJaxwsRuntimeMaven;
        result = result * 59 + ($addJaxwsRuntimeMaven == null ? 43 : ((Object)((Object)$addJaxwsRuntimeMaven)).hashCode());
        return result;
    }

    public static final class AddJaxwsRuntimeGradle
    extends Recipe {
        public String getDisplayName() {
            return "Use the latest JAX-WS API and runtime for Jakarta EE 8";
        }

        public String getDescription() {
            return "Update Gradle build files to use the latest JAX-WS runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater.  The recipe will add a JAX-WS run-time, in `compileOnly`+`testImplementation` configurations, to any project that has a transitive dependency on the JAX-WS API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return Preconditions.check((TreeVisitor)new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

                public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                    G.CompilationUnit g = cu;
                    GradleProject gp = (GradleProject)g.getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new RuntimeException("Gradle build scripts must have a GradleProject marker"));
                    Set<String> apiConfigurations = this.getTransitiveDependencyConfiguration(gp, AddJaxwsRuntime.JAKARTA_JAXWS_API_GROUP, AddJaxwsRuntime.JAKARTA_JAXWS_API_ARTIFACT);
                    if (!apiConfigurations.isEmpty()) {
                        Set<String> runtimeConfigurations = this.getTransitiveDependencyConfiguration(gp, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT);
                        if (runtimeConfigurations.isEmpty()) {
                            if (gp.getConfiguration("compileOnly") != null) {
                                g = (G.CompilationUnit)new AddDependencyVisitor(AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT, "2.3.x", null, "compileOnly", null, null, null, null).visitNonNull((Tree)g, (Object)ctx);
                            }
                            if (gp.getConfiguration("testImplementation") != null) {
                                g = (G.CompilationUnit)new AddDependencyVisitor(AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT, "2.3.x", null, "testImplementation", null, null, null, null).visitNonNull((Tree)g, (Object)ctx);
                            }
                        } else {
                            for (String apiConfiguration : apiConfigurations) {
                                GradleDependencyConfiguration apiGdc = gp.getConfiguration(apiConfiguration);
                                List apiTransitives = gp.configurationsExtendingFrom(apiGdc, true);
                                for (String runtimeConfiguration : runtimeConfigurations) {
                                    GradleDependencyConfiguration runtimeGdc = gp.getConfiguration(runtimeConfiguration);
                                    List runtimeTransitives = gp.configurationsExtendingFrom(runtimeGdc, true);
                                    if (!apiTransitives.stream().noneMatch(runtimeTransitives::contains)) continue;
                                    g = (G.CompilationUnit)new AddDependencyVisitor(AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT, "2.3.x", null, apiConfiguration, null, null, null, null).visitNonNull((Tree)g, (Object)ctx);
                                }
                            }
                        }
                    }
                    return g;
                }

                private Set<String> getTransitiveDependencyConfiguration(GradleProject gp, String groupId, String artifactId) {
                    GradleDependencyConfiguration gdc;
                    HashSet<String> configurations = new HashSet<String>();
                    for (GradleDependencyConfiguration gdc2 : gp.getConfigurations()) {
                        if (gdc2.findRequestedDependency(groupId, artifactId) == null && gdc2.findResolvedDependency(groupId, artifactId) == null) continue;
                        configurations.add(gdc2.getName());
                    }
                    HashSet tmpConfigurations = new HashSet(configurations);
                    for (String tmpConfiguration : tmpConfigurations) {
                        gdc = gp.getConfiguration(tmpConfiguration);
                        for (GradleDependencyConfiguration transitive : gp.configurationsExtendingFrom(gdc, true)) {
                            configurations.remove(transitive.getName());
                        }
                    }
                    tmpConfigurations = new HashSet(configurations);
                    for (String configuration : tmpConfigurations) {
                        gdc = gp.getConfiguration(configuration);
                        for (GradleDependencyConfiguration extendsFrom : gdc.allExtendsFrom()) {
                            if (!configurations.contains(extendsFrom.getName())) continue;
                            configurations.remove(configuration);
                        }
                    }
                    return configurations;
                }
            });
        }

        @NonNull
        public String toString() {
            return "AddJaxwsRuntime.AddJaxwsRuntimeGradle()";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddJaxwsRuntimeGradle)) {
                return false;
            }
            AddJaxwsRuntimeGradle other = (AddJaxwsRuntimeGradle)((Object)o);
            return other.canEqual((Object)this);
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof AddJaxwsRuntimeGradle;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static final class AddJaxwsRuntimeMaven
    extends Recipe {
        public String getDisplayName() {
            return "Use the latest JAX-WS API and runtime for Jakarta EE 8";
        }

        public String getDescription() {
            return "Update maven build files to use the latest JAX-WS runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater.  The recipe will add a JAX-WS run-time, in `provided` scope, to any project that has a transitive dependency on the JAX-WS API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new MavenIsoVisitor<ExecutionContext>(){

                public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                    Scope runtimeScope;
                    Xml.Document d = super.visitDocument(document, (Object)ctx);
                    MavenResolutionResult mavenModel = this.getResolutionResult();
                    Scope apiScope = this.getTransitiveDependencyScope(mavenModel, AddJaxwsRuntime.JAKARTA_JAXWS_API_GROUP, AddJaxwsRuntime.JAKARTA_JAXWS_API_ARTIFACT);
                    if (!(apiScope == null || (runtimeScope = this.getTransitiveDependencyScope(mavenModel, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT)) != null && apiScope.isInClasspathOf(runtimeScope))) {
                        String resolvedScope = apiScope == Scope.Test ? "test" : "provided";
                        d = (Xml.Document)new org.openrewrite.maven.AddDependencyVisitor(AddJaxwsRuntime.SUN_JAXWS_RUNTIME_GROUP, AddJaxwsRuntime.SUN_JAXWS_RUNTIME_ARTIFACT, "2.3.x", null, resolvedScope, null, null, null, null, null).visit((Tree)d, (Object)ctx);
                    }
                    return d;
                }
            };
        }

        @Nullable
        private Scope getTransitiveDependencyScope(MavenResolutionResult mavenModel, String groupId, String artifactId) {
            Scope maxScope = null;
            block0: for (Map.Entry entry : mavenModel.getDependencies().entrySet()) {
                for (ResolvedDependency dependency : (List)entry.getValue()) {
                    if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId())) continue;
                    if (!Scope.Compile.equals((Object)(maxScope = Scope.maxPrecedence(maxScope, (Scope)((Scope)entry.getKey()))))) continue block0;
                    return maxScope;
                }
            }
            return maxScope;
        }

        @NonNull
        public String toString() {
            return "AddJaxwsRuntime.AddJaxwsRuntimeMaven()";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddJaxwsRuntimeMaven)) {
                return false;
            }
            AddJaxwsRuntimeMaven other = (AddJaxwsRuntimeMaven)((Object)o);
            return other.canEqual((Object)this);
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof AddJaxwsRuntimeMaven;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }
}

