/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

public final class UseVarForObject
extends Recipe {
    public String getDisplayName() {
        return "Use `var` for reference-typed variables";
    }

    public String getDescription() {
        return "Try to apply local variable type inference `var` to variables containing Objects where possible. This recipe will not touch variable declarations with generics or initializers containing ternary operators.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new UseVarForObjectVisitor());
    }

    @NonNull
    public String toString() {
        return "UseVarForObject()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseVarForObject)) {
            return false;
        }
        UseVarForObject other = (UseVarForObject)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseVarForObject;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    static final class UseVarForObjectVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final JavaTemplate template = JavaTemplate.builder((String)"var #{} = #{any()}").contextSensitive().javaParser(JavaParser.fromJavaVersion()).build();

        UseVarForObjectVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isPrimitive = DeclarationCheck.isPrimitive(vd);
            boolean usesGenerics = DeclarationCheck.useGenerics(vd);
            boolean usesTernary = DeclarationCheck.initializedByTernary(vd);
            if (isPrimitive || usesGenerics || usesTernary) {
                return vd;
            }
            if (vd.getType() instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport((JavaType.FullyQualified)vd.getType());
            }
            return this.transformToVar(vd);
        }

        private J.VariableDeclarations transformToVar(J.VariableDeclarations vd) {
            Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
            String simpleName = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getSimpleName();
            if (vd.getModifiers().isEmpty()) {
                return (J.VariableDeclarations)this.template.apply(this.getCursor(), vd.getCoordinates().replace(), new Object[]{simpleName, initializer}).withPrefix(vd.getPrefix());
            }
            J.VariableDeclarations result = ((J.VariableDeclarations)this.template.apply(this.getCursor(), vd.getCoordinates().replace(), new Object[]{simpleName, initializer})).withModifiers(vd.getModifiers()).withPrefix(vd.getPrefix());
            TypeTree typeExpression = result.getTypeExpression();
            return typeExpression != null ? result.withTypeExpression((TypeTree)typeExpression.withPrefix(vd.getTypeExpression().getPrefix())) : vd;
        }
    }
}

