/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.plexus;

import java.util.Objects;
import org.codehaus.plexus.util.StringUtils;
import org.openrewrite.java.migrate.apache.commons.lang.RepeatableArgumentMatcher;
import org.openrewrite.java.template.Matches;

public class PlexusStringUtils {

    private static class Uppercase {
        private Uppercase() {
        }

        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.upperCase((String)s);
        }

        String after(String s) {
            return s == null ? null : s.toUpperCase();
        }
    }

    private static class Trim {
        private Trim() {
        }

        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.trim((String)s);
        }

        String after(String s) {
            return s == null ? null : s.trim();
        }
    }

    private static class Strip {
        private Strip() {
        }

        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.strip((String)s);
        }

        String after(String s) {
            return s == null ? null : s.trim();
        }
    }

    private static class Split {
        private Split() {
        }

        String[] before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.split((String)s);
        }

        String[] after(String s) {
            return s.split("\\s+");
        }
    }

    private static class Reverse {
        private Reverse() {
        }

        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.reverse((String)s);
        }

        String after(String s) {
            return s == null ? null : new StringBuilder(s).reverse().toString();
        }
    }

    private static class Replace {
        private Replace() {
        }

        String before(@Matches(value=RepeatableArgumentMatcher.class) String s, @Matches(value=RepeatableArgumentMatcher.class) String search, @Matches(value=RepeatableArgumentMatcher.class) String replacement) {
            return StringUtils.replace((String)s, (String)search, (String)replacement);
        }

        String after(String s, String search, String replacement) {
            return s == null || s.isEmpty() || search == null || search.isEmpty() || replacement == null ? s : s.replace(search, replacement);
        }
    }

    private static class Lowercase {
        private Lowercase() {
        }

        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.lowerCase((String)s);
        }

        String after(String s) {
            return s == null ? null : s.toLowerCase();
        }
    }

    private static class Equals {
        private Equals() {
        }

        boolean before(String s, String other) {
            return StringUtils.equals((String)s, (String)other);
        }

        boolean after(String s, String other) {
            return Objects.equals(s, other);
        }
    }

    private static class EqualsIgnoreCase {
        private EqualsIgnoreCase() {
        }

        boolean before(@Matches(value=RepeatableArgumentMatcher.class) String s, @Matches(value=RepeatableArgumentMatcher.class) String other) {
            return StringUtils.equalsIgnoreCase((String)s, (String)other);
        }

        boolean after(String s, String other) {
            return s == null ? other == null : s.equalsIgnoreCase(other);
        }
    }

    private static class DeleteWhitespace {
        private DeleteWhitespace() {
        }

        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.deleteWhitespace((String)s);
        }

        String after(String s) {
            return s.replaceAll("\\s+", "");
        }
    }

    private static class DefaultStringFallback {
        private DefaultStringFallback() {
        }

        String before(String s, String nullDefault) {
            return StringUtils.defaultString((Object)s, (String)nullDefault);
        }

        String after(String s, String nullDefault) {
            return Objects.toString(s, nullDefault);
        }
    }

    private static class DefaultString {
        private DefaultString() {
        }

        String before(String s) {
            return StringUtils.defaultString((Object)s);
        }

        String after(String s) {
            return Objects.toString(s, "");
        }
    }

    private static class Capitalize {
        private Capitalize() {
        }

        String before(@Matches(value=RepeatableArgumentMatcher.class) String s) {
            return StringUtils.capitalise((String)s);
        }

        String after(String s) {
            return s == null || s.isEmpty() ? s : Character.toTitleCase(s.charAt(0)) + s.substring(1);
        }
    }

    private static class Abbreviate {
        private Abbreviate() {
        }

        String before(@Matches(value=RepeatableArgumentMatcher.class) String s1, @Matches(value=RepeatableArgumentMatcher.class) int width) {
            return StringUtils.abbreviate((String)s1, (int)width);
        }

        String after(String s, int width) {
            return s.length() <= width ? s : s.substring(0, width - 3) + "...";
        }
    }
}

