/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.plexus;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public final class PlexusFileUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`PlexusFileUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.plexus.PlexusFileUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new DeleteDirectoryFileRecipe(), new DeleteDirectoryStringRecipe(), new FileExistsStringRecipe(), new GetFileRecipe()});
    }

    static class DeleteDirectoryFileRecipe
    extends Recipe {
        DeleteDirectoryFileRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `PlexusFileUtils.DeleteDirectoryFile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic class DeleteDirectoryFile {\n    \n    @BeforeTemplate\n    void before(File dir) throws Exception {\n        FileUtils.deleteDirectory(dir);\n    }\n    \n    @AfterTemplate\n    void after(File dir) throws Exception {\n        org.apache.commons.io.FileUtils.deleteDirectory(dir);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", dir -> org.codehaus.plexus.util.FileUtils.deleteDirectory((File)dir)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", dir -> FileUtils.deleteDirectory((File)dir)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true))}), (TreeVisitor)javaVisitor);
        }
    }

    static class DeleteDirectoryStringRecipe
    extends Recipe {
        DeleteDirectoryStringRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `PlexusFileUtils.DeleteDirectoryString`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic class DeleteDirectoryString {\n    \n    @BeforeTemplate\n    void before(String dir) throws Exception {\n        FileUtils.deleteDirectory(dir);\n    }\n    \n    @AfterTemplate\n    void after(String dir) throws Exception {\n        org.apache.commons.io.FileUtils.deleteDirectory(new File(dir));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", dir -> org.codehaus.plexus.util.FileUtils.deleteDirectory((String)dir)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", dir -> FileUtils.deleteDirectory((File)new File((String)dir))).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        this.maybeAddImport("java.io.File");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    static class FileExistsStringRecipe
    extends Recipe {
        FileExistsStringRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `PlexusFileUtils.FileExistsString`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic class FileExistsString {\n    \n    @BeforeTemplate\n    boolean before(String fileName) throws Exception {\n        return FileUtils.fileExists(fileName);\n    }\n    \n    @AfterTemplate\n    boolean after(String fileName) throws Exception {\n        return new File(fileName).exists();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", fileName -> org.codehaus.plexus.util.FileUtils.fileExists((String)fileName)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", fileName -> new File((String)fileName).exists()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        this.maybeAddImport("java.io.File");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    static class GetFileRecipe
    extends Recipe {
        GetFileRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `PlexusFileUtils.GetFile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic class GetFile {\n    \n    @BeforeTemplate\n    File before(String fileName) throws Exception {\n        return FileUtils.getFile(fileName);\n    }\n    \n    @AfterTemplate\n    File after(String fileName) throws Exception {\n        return new File(fileName);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", fileName -> org.codehaus.plexus.util.FileUtils.getFile((String)fileName)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", fileName -> new File((String)fileName)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.codehaus.plexus.util.FileUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.codehaus.plexus.util.FileUtils", Boolean.valueOf(true))}), (TreeVisitor)javaVisitor);
        }
    }
}

